/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;

public class ListIntentsIterable
implements SdkIterable<ListIntentsResponse> {
    private final LexModelsV2Client client;
    private final ListIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIntentsIterable(LexModelsV2Client client, ListIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIntentsResponseFetcher();
    }

    public Iterator<ListIntentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListIntentsResponseFetcher
    implements SyncPageFetcher<ListIntentsResponse> {
        private ListIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIntentsResponse nextPage(ListIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentsIterable.this.client.listIntents(ListIntentsIterable.this.firstRequest);
            }
            return ListIntentsIterable.this.client.listIntents((ListIntentsRequest)((Object)ListIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

