/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuiltinSlotTypeMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signature").getter(BuiltinSlotTypeMetadata.getter(BuiltinSlotTypeMetadata::signature)).setter(BuiltinSlotTypeMetadata.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_LOCALES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedLocales").getter(BuiltinSlotTypeMetadata.getter(BuiltinSlotTypeMetadata::supportedLocalesAsStrings)).setter(BuiltinSlotTypeMetadata.setter(Builder::supportedLocalesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLocales").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD, SUPPORTED_LOCALES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BuiltinSlotTypeMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String signature;
    private final List<String> supportedLocales;

    private BuiltinSlotTypeMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    public final String signature() {
        return this.signature;
    }

    public final List<Locale> supportedLocales() {
        return LocaleListCopier.copyStringToEnum(this.supportedLocales);
    }

    public final boolean hasSupportedLocales() {
        return this.supportedLocales != null && !(this.supportedLocales instanceof SdkAutoConstructList);
    }

    public final List<String> supportedLocalesAsStrings() {
        return this.supportedLocales;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedLocales() ? this.supportedLocalesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata)obj;
        return Objects.equals(this.signature(), other.signature()) && this.hasSupportedLocales() == other.hasSupportedLocales() && Objects.equals(this.supportedLocalesAsStrings(), other.supportedLocalesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BuiltinSlotTypeMetadata").add("Signature", (Object)this.signature()).add("SupportedLocales", this.hasSupportedLocales() ? this.supportedLocalesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "supportedLocales": {
                return Optional.ofNullable(clazz.cast(this.supportedLocalesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("signature", SIGNATURE_FIELD);
        map.put("supportedLocales", SUPPORTED_LOCALES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuiltinSlotTypeMetadata, T> g) {
        return obj -> g.apply((BuiltinSlotTypeMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinSlotTypeMetadata model) {
            this.signature(model.signature);
            this.supportedLocalesWithStrings(model.supportedLocales);
        }

        public final String getSignature() {
            return this.signature;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final Collection<String> getSupportedLocales() {
            if (this.supportedLocales instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedLocales;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @Override
        public final Builder supportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocalesWithStrings(String ... supportedLocales) {
            this.supportedLocalesWithStrings(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public final Builder supportedLocales(Collection<Locale> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copyEnumToString(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public BuiltinSlotTypeMetadata build() {
            return new BuiltinSlotTypeMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
        public Builder signature(String var1);

        public Builder supportedLocalesWithStrings(Collection<String> var1);

        public Builder supportedLocalesWithStrings(String ... var1);

        public Builder supportedLocales(Collection<Locale> var1);

        public Builder supportedLocales(Locale ... var1);
    }
}

