/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.services.lexmodelbuilding.model.FollowUpPrompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.FulfillmentActivity;
import software.amazon.awssdk.services.lexmodelbuilding.model.InputContext;
import software.amazon.awssdk.services.lexmodelbuilding.model.InputContextListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.KendraConfiguration;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.OutputContext;
import software.amazon.awssdk.services.lexmodelbuilding.model.OutputContextListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Slot;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntentRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, PutIntentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutIntentRequest.getter(PutIntentRequest::name)).setter(PutIntentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutIntentRequest.getter(PutIntentRequest::description)).setter(PutIntentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slots").getter(PutIntentRequest.getter(PutIntentRequest::slots)).setter(PutIntentRequest.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(PutIntentRequest.getter(PutIntentRequest::sampleUtterances)).setter(PutIntentRequest.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Prompt> CONFIRMATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationPrompt").getter(PutIntentRequest.getter(PutIntentRequest::confirmationPrompt)).setter(PutIntentRequest.setter(Builder::confirmationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationPrompt").build()}).build();
    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rejectionStatement").getter(PutIntentRequest.getter(PutIntentRequest::rejectionStatement)).setter(PutIntentRequest.setter(Builder::rejectionStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build()}).build();
    private static final SdkField<FollowUpPrompt> FOLLOW_UP_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("followUpPrompt").getter(PutIntentRequest.getter(PutIntentRequest::followUpPrompt)).setter(PutIntentRequest.setter(Builder::followUpPrompt)).constructor(FollowUpPrompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followUpPrompt").build()}).build();
    private static final SdkField<Statement> CONCLUSION_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conclusionStatement").getter(PutIntentRequest.getter(PutIntentRequest::conclusionStatement)).setter(PutIntentRequest.setter(Builder::conclusionStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conclusionStatement").build()}).build();
    private static final SdkField<CodeHook> DIALOG_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogCodeHook").getter(PutIntentRequest.getter(PutIntentRequest::dialogCodeHook)).setter(PutIntentRequest.setter(Builder::dialogCodeHook)).constructor(CodeHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()}).build();
    private static final SdkField<FulfillmentActivity> FULFILLMENT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fulfillmentActivity").getter(PutIntentRequest.getter(PutIntentRequest::fulfillmentActivity)).setter(PutIntentRequest.setter(Builder::fulfillmentActivity)).constructor(FulfillmentActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentActivity").build()}).build();
    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIntentSignature").getter(PutIntentRequest.getter(PutIntentRequest::parentIntentSignature)).setter(PutIntentRequest.setter(Builder::parentIntentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(PutIntentRequest.getter(PutIntentRequest::checksum)).setter(PutIntentRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createVersion").getter(PutIntentRequest.getter(PutIntentRequest::createVersion)).setter(PutIntentRequest.setter(Builder::createVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()}).build();
    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kendraConfiguration").getter(PutIntentRequest.getter(PutIntentRequest::kendraConfiguration)).setter(PutIntentRequest.setter(Builder::kendraConfiguration)).constructor(KendraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build()}).build();
    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputContexts").getter(PutIntentRequest.getter(PutIntentRequest::inputContexts)).setter(PutIntentRequest.setter(Builder::inputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputContexts").getter(PutIntentRequest.getter(PutIntentRequest::outputContexts)).setter(PutIntentRequest.setter(Builder::outputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SLOTS_FIELD, SAMPLE_UTTERANCES_FIELD, CONFIRMATION_PROMPT_FIELD, REJECTION_STATEMENT_FIELD, FOLLOW_UP_PROMPT_FIELD, CONCLUSION_STATEMENT_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_ACTIVITY_FIELD, PARENT_INTENT_SIGNATURE_FIELD, CHECKSUM_FIELD, CREATE_VERSION_FIELD, KENDRA_CONFIGURATION_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD));
    private final String name;
    private final String description;
    private final List<Slot> slots;
    private final List<String> sampleUtterances;
    private final Prompt confirmationPrompt;
    private final Statement rejectionStatement;
    private final FollowUpPrompt followUpPrompt;
    private final Statement conclusionStatement;
    private final CodeHook dialogCodeHook;
    private final FulfillmentActivity fulfillmentActivity;
    private final String parentIntentSignature;
    private final String checksum;
    private final Boolean createVersion;
    private final KendraConfiguration kendraConfiguration;
    private final List<InputContext> inputContexts;
    private final List<OutputContext> outputContexts;

    private PutIntentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.checksum = builder.checksum;
        this.createVersion = builder.createVersion;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructList);
    }

    public final List<Slot> slots() {
        return this.slots;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final Prompt confirmationPrompt() {
        return this.confirmationPrompt;
    }

    public final Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public final FollowUpPrompt followUpPrompt() {
        return this.followUpPrompt;
    }

    public final Statement conclusionStatement() {
        return this.conclusionStatement;
    }

    public final CodeHook dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public final FulfillmentActivity fulfillmentActivity() {
        return this.fulfillmentActivity;
    }

    public final String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final Boolean createVersion() {
        return this.createVersion;
    }

    public final KendraConfiguration kendraConfiguration() {
        return this.kendraConfiguration;
    }

    public final boolean hasInputContexts() {
        return this.inputContexts != null && !(this.inputContexts instanceof SdkAutoConstructList);
    }

    public final List<InputContext> inputContexts() {
        return this.inputContexts;
    }

    public final boolean hasOutputContexts() {
        return this.outputContexts != null && !(this.outputContexts instanceof SdkAutoConstructList);
    }

    public final List<OutputContext> outputContexts() {
        return this.outputContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlots() ? this.slots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputContexts() ? this.inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputContexts() ? this.outputContexts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentRequest)) {
            return false;
        }
        PutIntentRequest other = (PutIntentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasSlots() == other.hasSlots() && Objects.equals(this.slots(), other.slots()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.confirmationPrompt(), other.confirmationPrompt()) && Objects.equals(this.rejectionStatement(), other.rejectionStatement()) && Objects.equals(this.followUpPrompt(), other.followUpPrompt()) && Objects.equals(this.conclusionStatement(), other.conclusionStatement()) && Objects.equals(this.dialogCodeHook(), other.dialogCodeHook()) && Objects.equals(this.fulfillmentActivity(), other.fulfillmentActivity()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.createVersion(), other.createVersion()) && Objects.equals(this.kendraConfiguration(), other.kendraConfiguration()) && this.hasInputContexts() == other.hasInputContexts() && Objects.equals(this.inputContexts(), other.inputContexts()) && this.hasOutputContexts() == other.hasOutputContexts() && Objects.equals(this.outputContexts(), other.outputContexts());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntentRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Slots", this.hasSlots() ? this.slots() : null).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("ConfirmationPrompt", (Object)this.confirmationPrompt()).add("RejectionStatement", (Object)this.rejectionStatement()).add("FollowUpPrompt", (Object)this.followUpPrompt()).add("ConclusionStatement", (Object)this.conclusionStatement()).add("DialogCodeHook", (Object)this.dialogCodeHook()).add("FulfillmentActivity", (Object)this.fulfillmentActivity()).add("ParentIntentSignature", (Object)this.parentIntentSignature()).add("Checksum", (Object)this.checksum()).add("CreateVersion", (Object)this.createVersion()).add("KendraConfiguration", (Object)this.kendraConfiguration()).add("InputContexts", this.hasInputContexts() ? this.inputContexts() : null).add("OutputContexts", this.hasOutputContexts() ? this.outputContexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "confirmationPrompt": {
                return Optional.ofNullable(clazz.cast(this.confirmationPrompt()));
            }
            case "rejectionStatement": {
                return Optional.ofNullable(clazz.cast(this.rejectionStatement()));
            }
            case "followUpPrompt": {
                return Optional.ofNullable(clazz.cast(this.followUpPrompt()));
            }
            case "conclusionStatement": {
                return Optional.ofNullable(clazz.cast(this.conclusionStatement()));
            }
            case "dialogCodeHook": {
                return Optional.ofNullable(clazz.cast(this.dialogCodeHook()));
            }
            case "fulfillmentActivity": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentActivity()));
            }
            case "parentIntentSignature": {
                return Optional.ofNullable(clazz.cast(this.parentIntentSignature()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "createVersion": {
                return Optional.ofNullable(clazz.cast(this.createVersion()));
            }
            case "kendraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kendraConfiguration()));
            }
            case "inputContexts": {
                return Optional.ofNullable(clazz.cast(this.inputContexts()));
            }
            case "outputContexts": {
                return Optional.ofNullable(clazz.cast(this.outputContexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntentRequest, T> g) {
        return obj -> g.apply((PutIntentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();
        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private Prompt confirmationPrompt;
        private Statement rejectionStatement;
        private FollowUpPrompt followUpPrompt;
        private Statement conclusionStatement;
        private CodeHook dialogCodeHook;
        private FulfillmentActivity fulfillmentActivity;
        private String parentIntentSignature;
        private String checksum;
        private Boolean createVersion;
        private KendraConfiguration kendraConfiguration;
        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();
        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntentRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.slots(model.slots);
            this.sampleUtterances(model.sampleUtterances);
            this.confirmationPrompt(model.confirmationPrompt);
            this.rejectionStatement(model.rejectionStatement);
            this.followUpPrompt(model.followUpPrompt);
            this.conclusionStatement(model.conclusionStatement);
            this.dialogCodeHook(model.dialogCodeHook);
            this.fulfillmentActivity(model.fulfillmentActivity);
            this.parentIntentSignature(model.parentIntentSignature);
            this.checksum(model.checksum);
            this.createVersion(model.createVersion);
            this.kendraConfiguration(model.kendraConfiguration);
            this.inputContexts(model.inputContexts);
            this.outputContexts(model.outputContexts);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Slot.Builder> getSlots() {
            List<Slot.Builder> result = SlotListCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder> ... slots) {
            this.slots(Stream.of(slots).map(c -> (Slot)((Slot.Builder)Slot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSampleUtterances() {
            if (this.sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sampleUtterances;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return this.confirmationPrompt != null ? this.confirmationPrompt.toBuilder() : null;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final Statement.Builder getRejectionStatement() {
            return this.rejectionStatement != null ? this.rejectionStatement.toBuilder() : null;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return this.followUpPrompt != null ? this.followUpPrompt.toBuilder() : null;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final Statement.Builder getConclusionStatement() {
            return this.conclusionStatement != null ? this.conclusionStatement.toBuilder() : null;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return this.dialogCodeHook != null ? this.dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return this.fulfillmentActivity != null ? this.fulfillmentActivity.toBuilder() : null;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Boolean getCreateVersion() {
            return this.createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return this.kendraConfiguration != null ? this.kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext ... inputContexts) {
            this.inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder> ... inputContexts) {
            this.inputContexts(Stream.of(inputContexts).map(c -> (InputContext)((InputContext.Builder)InputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext ... outputContexts) {
            this.outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder> ... outputContexts) {
            this.outputContexts(Stream.of(outputContexts).map(c -> (OutputContext)((OutputContext.Builder)OutputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntentRequest build() {
            return new PutIntentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntentRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slots(Collection<Slot> var1);

        public Builder slots(Slot ... var1);

        public Builder slots(Consumer<Slot.Builder> ... var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder confirmationPrompt(Prompt var1);

        default public Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return this.confirmationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(confirmationPrompt)).build());
        }

        public Builder rejectionStatement(Statement var1);

        default public Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return this.rejectionStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(rejectionStatement)).build());
        }

        public Builder followUpPrompt(FollowUpPrompt var1);

        default public Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return this.followUpPrompt((FollowUpPrompt)((FollowUpPrompt.Builder)FollowUpPrompt.builder().applyMutation(followUpPrompt)).build());
        }

        public Builder conclusionStatement(Statement var1);

        default public Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return this.conclusionStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(conclusionStatement)).build());
        }

        public Builder dialogCodeHook(CodeHook var1);

        default public Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return this.dialogCodeHook((CodeHook)((CodeHook.Builder)CodeHook.builder().applyMutation(dialogCodeHook)).build());
        }

        public Builder fulfillmentActivity(FulfillmentActivity var1);

        default public Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return this.fulfillmentActivity((FulfillmentActivity)((FulfillmentActivity.Builder)FulfillmentActivity.builder().applyMutation(fulfillmentActivity)).build());
        }

        public Builder parentIntentSignature(String var1);

        public Builder checksum(String var1);

        public Builder createVersion(Boolean var1);

        public Builder kendraConfiguration(KendraConfiguration var1);

        default public Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return this.kendraConfiguration((KendraConfiguration)((KendraConfiguration.Builder)KendraConfiguration.builder().applyMutation(kendraConfiguration)).build());
        }

        public Builder inputContexts(Collection<InputContext> var1);

        public Builder inputContexts(InputContext ... var1);

        public Builder inputContexts(Consumer<InputContext.Builder> ... var1);

        public Builder outputContexts(Collection<OutputContext> var1);

        public Builder outputContexts(OutputContext ... var1);

        public Builder outputContexts(Consumer<OutputContext.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

