/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportType {
    ALEXA_SKILLS_KIT("ALEXA_SKILLS_KIT"),
    LEX("LEX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportType> VALUE_MAP;
    private final String value;

    private ExportType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportType> knownValues() {
        EnumSet<ExportType> knownValues = EnumSet.allOf(ExportType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportType.class, ExportType::toString);
    }
}

