/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsCopier;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardRequest;
import software.amazon.awssdk.services.launchwizard.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends LaunchWizardRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentPatternName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::deploymentPatternName)).setter(CreateDeploymentRequest.setter(Builder::deploymentPatternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dryRun").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::dryRun)).setter(CreateDeploymentRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::name)).setter(CreateDeploymentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("specifications").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::specifications)).setter(CreateDeploymentRequest.setter(Builder::specifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::tags)).setter(CreateDeploymentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::workloadName)).setter(CreateDeploymentRequest.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD, DRY_RUN_FIELD, NAME_FIELD, SPECIFICATIONS_FIELD, TAGS_FIELD, WORKLOAD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeploymentRequest.memberNameToFieldInitializer();
    private final String deploymentPatternName;
    private final Boolean dryRun;
    private final String name;
    private final Map<String, String> specifications;
    private final Map<String, String> tags;
    private final String workloadName;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentPatternName = builder.deploymentPatternName;
        this.dryRun = builder.dryRun;
        this.name = builder.name;
        this.specifications = builder.specifications;
        this.tags = builder.tags;
        this.workloadName = builder.workloadName;
    }

    public final String deploymentPatternName() {
        return this.deploymentPatternName;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSpecifications() {
        return this.specifications != null && !(this.specifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> specifications() {
        return this.specifications;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecifications() ? this.specifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.deploymentPatternName(), other.deploymentPatternName()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.name(), other.name()) && this.hasSpecifications() == other.hasSpecifications() && Objects.equals(this.specifications(), other.specifications()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("DeploymentPatternName", (Object)this.deploymentPatternName()).add("DryRun", (Object)this.dryRun()).add("Name", (Object)this.name()).add("Specifications", (Object)(this.specifications() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentPatternName": {
                return Optional.ofNullable(clazz.cast(this.deploymentPatternName()));
            }
            case "dryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "specifications": {
                return Optional.ofNullable(clazz.cast(this.specifications()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deploymentPatternName", DEPLOYMENT_PATTERN_NAME_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("specifications", SPECIFICATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LaunchWizardRequest.BuilderImpl
    implements Builder {
        private String deploymentPatternName;
        private Boolean dryRun;
        private String name;
        private Map<String, String> specifications = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.deploymentPatternName(model.deploymentPatternName);
            this.dryRun(model.dryRun);
            this.name(model.name);
            this.specifications(model.specifications);
            this.tags(model.tags);
            this.workloadName(model.workloadName);
        }

        public final String getDeploymentPatternName() {
            return this.deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getSpecifications() {
            if (this.specifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.specifications;
        }

        public final void setSpecifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
        }

        @Override
        public final Builder specifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LaunchWizardRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder deploymentPatternName(String var1);

        public Builder dryRun(Boolean var1);

        public Builder name(String var1);

        public Builder specifications(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder workloadName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

