/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary;
import software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummaryListCopier;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentEventsResponse
extends LaunchWizardResponse
implements ToCopyableBuilder<Builder, ListDeploymentEventsResponse> {
    private static final SdkField<List<DeploymentEventDataSummary>> DEPLOYMENT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentEvents").getter(ListDeploymentEventsResponse.getter(ListDeploymentEventsResponse::deploymentEvents)).setter(ListDeploymentEventsResponse.setter(Builder::deploymentEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentEventDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeploymentEventsResponse.getter(ListDeploymentEventsResponse::nextToken)).setter(ListDeploymentEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deploymentEvents", DEPLOYMENT_EVENTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DeploymentEventDataSummary> deploymentEvents;
    private final String nextToken;

    private ListDeploymentEventsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentEvents = builder.deploymentEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeploymentEvents() {
        return this.deploymentEvents != null && !(this.deploymentEvents instanceof SdkAutoConstructList);
    }

    public final List<DeploymentEventDataSummary> deploymentEvents() {
        return this.deploymentEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentEvents() ? this.deploymentEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentEventsResponse)) {
            return false;
        }
        ListDeploymentEventsResponse other = (ListDeploymentEventsResponse)((Object)obj);
        return this.hasDeploymentEvents() == other.hasDeploymentEvents() && Objects.equals(this.deploymentEvents(), other.deploymentEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeploymentEventsResponse").add("DeploymentEvents", this.hasDeploymentEvents() ? this.deploymentEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentEvents": {
                return Optional.ofNullable(clazz.cast(this.deploymentEvents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentEventsResponse, T> g) {
        return obj -> g.apply((ListDeploymentEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LaunchWizardResponse.BuilderImpl
    implements Builder {
        private List<DeploymentEventDataSummary> deploymentEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentEventsResponse model) {
            super(model);
            this.deploymentEvents(model.deploymentEvents);
            this.nextToken(model.nextToken);
        }

        public final List<DeploymentEventDataSummary.Builder> getDeploymentEvents() {
            List<DeploymentEventDataSummary.Builder> result = DeploymentEventDataSummaryListCopier.copyToBuilder(this.deploymentEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentEvents(Collection<DeploymentEventDataSummary.BuilderImpl> deploymentEvents) {
            this.deploymentEvents = DeploymentEventDataSummaryListCopier.copyFromBuilder(deploymentEvents);
        }

        @Override
        public final Builder deploymentEvents(Collection<DeploymentEventDataSummary> deploymentEvents) {
            this.deploymentEvents = DeploymentEventDataSummaryListCopier.copy(deploymentEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentEvents(DeploymentEventDataSummary ... deploymentEvents) {
            this.deploymentEvents(Arrays.asList(deploymentEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentEvents(Consumer<DeploymentEventDataSummary.Builder> ... deploymentEvents) {
            this.deploymentEvents(Stream.of(deploymentEvents).map(c -> (DeploymentEventDataSummary)((DeploymentEventDataSummary.Builder)DeploymentEventDataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeploymentEventsResponse build() {
            return new ListDeploymentEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LaunchWizardResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentEventsResponse> {
        public Builder deploymentEvents(Collection<DeploymentEventDataSummary> var1);

        public Builder deploymentEvents(DeploymentEventDataSummary ... var1);

        public Builder deploymentEvents(Consumer<DeploymentEventDataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

