/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.launchwizard.LaunchWizardClient;
import software.amazon.awssdk.services.launchwizard.internal.UserAgentUtils;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary;

public class ListWorkloadsIterable
implements SdkIterable<ListWorkloadsResponse> {
    private final LaunchWizardClient client;
    private final ListWorkloadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadsIterable(LaunchWizardClient client, ListWorkloadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadsResponseFetcher();
    }

    public Iterator<ListWorkloadsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadDataSummary> workloads() {
        Function<ListWorkloadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workloads() != null) {
                return response.workloads().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkloadsResponseFetcher
    implements SyncPageFetcher<ListWorkloadsResponse> {
        private ListWorkloadsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadsResponse nextPage(ListWorkloadsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadsIterable.this.client.listWorkloads(ListWorkloadsIterable.this.firstRequest);
            }
            return ListWorkloadsIterable.this.client.listWorkloads((ListWorkloadsRequest)((Object)ListWorkloadsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

