/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.launchwizard.LaunchWizardAsyncClient;
import software.amazon.awssdk.services.launchwizard.internal.UserAgentUtils;
import software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse;

public class ListDeploymentEventsPublisher
implements SdkPublisher<ListDeploymentEventsResponse> {
    private final LaunchWizardAsyncClient client;
    private final ListDeploymentEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentEventsPublisher(LaunchWizardAsyncClient client, ListDeploymentEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentEventsPublisher(LaunchWizardAsyncClient client, ListDeploymentEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeploymentEventDataSummary> deploymentEvents() {
        Function<ListDeploymentEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentEvents() != null) {
                return response.deploymentEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeploymentEventsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentEventsResponse> {
        private ListDeploymentEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentEventsResponse> nextPage(ListDeploymentEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentEventsPublisher.this.client.listDeploymentEvents(ListDeploymentEventsPublisher.this.firstRequest);
            }
            return ListDeploymentEventsPublisher.this.client.listDeploymentEvents((ListDeploymentEventsRequest)((Object)ListDeploymentEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

