/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.launchwizard.DefaultLaunchWizardAsyncClient;
import software.amazon.awssdk.services.launchwizard.DefaultLaunchWizardBaseClientBuilder;
import software.amazon.awssdk.services.launchwizard.LaunchWizardAsyncClient;
import software.amazon.awssdk.services.launchwizard.LaunchWizardAsyncClientBuilder;
import software.amazon.awssdk.services.launchwizard.LaunchWizardServiceClientConfiguration;
import software.amazon.awssdk.services.launchwizard.endpoints.LaunchWizardEndpointProvider;

@SdkInternalApi
final class DefaultLaunchWizardAsyncClientBuilder
extends DefaultLaunchWizardBaseClientBuilder<LaunchWizardAsyncClientBuilder, LaunchWizardAsyncClient>
implements LaunchWizardAsyncClientBuilder {
    DefaultLaunchWizardAsyncClientBuilder() {
    }

    @Override
    public DefaultLaunchWizardAsyncClientBuilder endpointProvider(LaunchWizardEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LaunchWizardAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLaunchWizardAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LaunchWizardServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLaunchWizardAsyncClient client = new DefaultLaunchWizardAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LaunchWizardServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LaunchWizardServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

