/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.InvocationType;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, InvokeRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeRequest.getter(InvokeRequest::functionName)).setter(InvokeRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeRequest.getter(InvokeRequest::invocationTypeAsString)).setter(InvokeRequest.setter(Builder::invocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Invocation-Type").build()}).build();
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeRequest.getter(InvokeRequest::logTypeAsString)).setter(InvokeRequest.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Type").build()}).build();
    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeRequest.getter(InvokeRequest::clientContext)).setter(InvokeRequest.setter(Builder::clientContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Context").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(InvokeRequest.getter(InvokeRequest::payload)).setter(InvokeRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeRequest.getter(InvokeRequest::qualifier)).setter(InvokeRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, INVOCATION_TYPE_FIELD, LOG_TYPE_FIELD, CLIENT_CONTEXT_FIELD, PAYLOAD_FIELD, QUALIFIER_FIELD));
    private final String functionName;
    private final String invocationType;
    private final String logType;
    private final String clientContext;
    private final SdkBytes payload;
    private final String qualifier;

    private InvokeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.payload = builder.payload;
        this.qualifier = builder.qualifier;
    }

    public String functionName() {
        return this.functionName;
    }

    public InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public String invocationTypeAsString() {
        return this.invocationType;
    }

    public LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public String logTypeAsString() {
        return this.logType;
    }

    public String clientContext() {
        return this.clientContext;
    }

    public SdkBytes payload() {
        return this.payload;
    }

    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString()) && Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.qualifier(), other.qualifier());
    }

    public String toString() {
        return ToString.builder((String)"InvokeRequest").add("FunctionName", (Object)this.functionName()).add("InvocationType", (Object)this.invocationTypeAsString()).add("LogType", (Object)this.logTypeAsString()).add("ClientContext", (Object)this.clientContext()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("Qualifier", (Object)this.qualifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "InvocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeRequest, T> g) {
        return obj -> g.apply((InvokeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String invocationType;
        private String logType;
        private String clientContext;
        private SdkBytes payload;
        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.invocationType(model.invocationType);
            this.logType(model.logType);
            this.clientContext(model.clientContext);
            this.payload(model.payload);
            this.qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getInvocationTypeAsString() {
            return this.invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        public final String getLogTypeAsString() {
            return this.logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy((SdkBytes)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRequest build() {
            return new InvokeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeRequest> {
        public Builder functionName(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder clientContext(String var1);

        public Builder payload(SdkBytes var1);

        public Builder qualifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

