/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ThrottleReason {
    CONCURRENT_INVOCATION_LIMIT_EXCEEDED("ConcurrentInvocationLimitExceeded"),
    FUNCTION_INVOCATION_RATE_LIMIT_EXCEEDED("FunctionInvocationRateLimitExceeded"),
    RESERVED_FUNCTION_CONCURRENT_INVOCATION_LIMIT_EXCEEDED("ReservedFunctionConcurrentInvocationLimitExceeded"),
    RESERVED_FUNCTION_INVOCATION_RATE_LIMIT_EXCEEDED("ReservedFunctionInvocationRateLimitExceeded"),
    CALLER_RATE_LIMIT_EXCEEDED("CallerRateLimitExceeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ThrottleReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThrottleReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ThrottleReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThrottleReason> knownValues() {
        return Stream.of(ThrottleReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

