/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Execution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Execution> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionArn").getter(Execution.getter(Execution::durableExecutionArn)).setter(Execution.setter(Builder::durableExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionArn").build()}).build();
    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionName").getter(Execution.getter(Execution::durableExecutionName)).setter(Execution.setter(Builder::durableExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionName").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(Execution.getter(Execution::functionArn)).setter(Execution.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Execution.getter(Execution::statusAsString)).setter(Execution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(Execution.getter(Execution::startTimestamp)).setter(Execution.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(Execution.getter(Execution::endTimestamp)).setter(Execution.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD, DURABLE_EXECUTION_NAME_FIELD, FUNCTION_ARN_FIELD, STATUS_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Execution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String durableExecutionArn;
    private final String durableExecutionName;
    private final String functionArn;
    private final String status;
    private final Instant startTimestamp;
    private final Instant endTimestamp;

    private Execution(BuilderImpl builder) {
        this.durableExecutionArn = builder.durableExecutionArn;
        this.durableExecutionName = builder.durableExecutionName;
        this.functionArn = builder.functionArn;
        this.status = builder.status;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    public final String durableExecutionArn() {
        return this.durableExecutionArn;
    }

    public final String durableExecutionName() {
        return this.durableExecutionName;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Execution)) {
            return false;
        }
        Execution other = (Execution)obj;
        return Objects.equals(this.durableExecutionArn(), other.durableExecutionArn()) && Objects.equals(this.durableExecutionName(), other.durableExecutionName()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Execution").add("DurableExecutionArn", (Object)this.durableExecutionArn()).add("DurableExecutionName", (Object)this.durableExecutionName()).add("FunctionArn", (Object)this.functionArn()).add("Status", (Object)this.statusAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurableExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionArn()));
            }
            case "DurableExecutionName": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionName()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Execution, T> g) {
        return obj -> g.apply((Execution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String durableExecutionArn;
        private String durableExecutionName;
        private String functionArn;
        private String status;
        private Instant startTimestamp;
        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Execution model) {
            this.durableExecutionArn(model.durableExecutionArn);
            this.durableExecutionName(model.durableExecutionName);
            this.functionArn(model.functionArn);
            this.status(model.status);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
        }

        public final String getDurableExecutionArn() {
            return this.durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getDurableExecutionName() {
            return this.durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Execution build() {
            return new Execution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Execution> {
        public Builder durableExecutionArn(String var1);

        public Builder durableExecutionName(String var1);

        public Builder functionArn(String var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);
    }
}

