/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.Event;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionHistoryRequest;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionHistoryResponse;

public class GetDurableExecutionHistoryPublisher
implements SdkPublisher<GetDurableExecutionHistoryResponse> {
    private final LambdaAsyncClient client;
    private final GetDurableExecutionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDurableExecutionHistoryPublisher(LambdaAsyncClient client, GetDurableExecutionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDurableExecutionHistoryPublisher(LambdaAsyncClient client, GetDurableExecutionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDurableExecutionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDurableExecutionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<GetDurableExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDurableExecutionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDurableExecutionHistoryResponseFetcher
    implements AsyncPageFetcher<GetDurableExecutionHistoryResponse> {
        private GetDurableExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetDurableExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<GetDurableExecutionHistoryResponse> nextPage(GetDurableExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetDurableExecutionHistoryPublisher.this.client.getDurableExecutionHistory(GetDurableExecutionHistoryPublisher.this.firstRequest);
            }
            return GetDurableExecutionHistoryPublisher.this.client.getDurableExecutionHistory((GetDurableExecutionHistoryRequest)((Object)GetDurableExecutionHistoryPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

