/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CapacityProviderState;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCapacityProvidersRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, ListCapacityProvidersRequest> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListCapacityProvidersRequest.getter(ListCapacityProvidersRequest::stateAsString)).setter(ListCapacityProvidersRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListCapacityProvidersRequest.getter(ListCapacityProvidersRequest::marker)).setter(ListCapacityProvidersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListCapacityProvidersRequest.getter(ListCapacityProvidersRequest::maxItems)).setter(ListCapacityProvidersRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCapacityProvidersRequest.memberNameToFieldInitializer();
    private final String state;
    private final String marker;
    private final Integer maxItems;

    private ListCapacityProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final CapacityProviderState state() {
        return CapacityProviderState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityProvidersRequest)) {
            return false;
        }
        ListCapacityProvidersRequest other = (ListCapacityProvidersRequest)((Object)obj);
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListCapacityProvidersRequest").add("State", (Object)this.stateAsString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityProvidersRequest, T> g) {
        return obj -> g.apply((ListCapacityProvidersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String state;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityProvidersRequest model) {
            super(model);
            this.state(model.state);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityProviderState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCapacityProvidersRequest build() {
            return new ListCapacityProvidersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCapacityProvidersRequest> {
        public Builder state(String var1);

        public Builder state(CapacityProviderState var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

