/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDurableExecutionStateRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, GetDurableExecutionStateRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionArn").getter(GetDurableExecutionStateRequest.getter(GetDurableExecutionStateRequest::durableExecutionArn)).setter(GetDurableExecutionStateRequest.setter(Builder::durableExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()}).build();
    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckpointToken").getter(GetDurableExecutionStateRequest.getter(GetDurableExecutionStateRequest::checkpointToken)).setter(GetDurableExecutionStateRequest.setter(Builder::checkpointToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CheckpointToken").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetDurableExecutionStateRequest.getter(GetDurableExecutionStateRequest::marker)).setter(GetDurableExecutionStateRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(GetDurableExecutionStateRequest.getter(GetDurableExecutionStateRequest::maxItems)).setter(GetDurableExecutionStateRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD, CHECKPOINT_TOKEN_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDurableExecutionStateRequest.memberNameToFieldInitializer();
    private final String durableExecutionArn;
    private final String checkpointToken;
    private final String marker;
    private final Integer maxItems;

    private GetDurableExecutionStateRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.checkpointToken = builder.checkpointToken;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String durableExecutionArn() {
        return this.durableExecutionArn;
    }

    public final String checkpointToken() {
        return this.checkpointToken;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionStateRequest)) {
            return false;
        }
        GetDurableExecutionStateRequest other = (GetDurableExecutionStateRequest)((Object)obj);
        return Objects.equals(this.durableExecutionArn(), other.durableExecutionArn()) && Objects.equals(this.checkpointToken(), other.checkpointToken()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"GetDurableExecutionStateRequest").add("DurableExecutionArn", (Object)this.durableExecutionArn()).add("CheckpointToken", (Object)this.checkpointToken()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurableExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionArn()));
            }
            case "CheckpointToken": {
                return Optional.ofNullable(clazz.cast(this.checkpointToken()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionStateRequest, T> g) {
        return obj -> g.apply((GetDurableExecutionStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String durableExecutionArn;
        private String checkpointToken;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionStateRequest model) {
            super(model);
            this.durableExecutionArn(model.durableExecutionArn);
            this.checkpointToken(model.checkpointToken);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getDurableExecutionArn() {
            return this.durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getCheckpointToken() {
            return this.checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDurableExecutionStateRequest build() {
            return new GetDurableExecutionStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDurableExecutionStateRequest> {
        public Builder durableExecutionArn(String var1);

        public Builder checkpointToken(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

