/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.InvocationType;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, InvokeRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(InvokeRequest.getter(InvokeRequest::functionName)).setter(InvokeRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationType").getter(InvokeRequest.getter(InvokeRequest::invocationTypeAsString)).setter(InvokeRequest.setter(Builder::invocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Invocation-Type").build()}).build();
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogType").getter(InvokeRequest.getter(InvokeRequest::logTypeAsString)).setter(InvokeRequest.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Type").build()}).build();
    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientContext").getter(InvokeRequest.getter(InvokeRequest::clientContext)).setter(InvokeRequest.setter(Builder::clientContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Context").build()}).build();
    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionName").getter(InvokeRequest.getter(InvokeRequest::durableExecutionName)).setter(InvokeRequest.setter(Builder::durableExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Durable-Execution-Name").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Payload").getter(InvokeRequest.getter(InvokeRequest::payload)).setter(InvokeRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(InvokeRequest.getter(InvokeRequest::qualifier)).setter(InvokeRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(InvokeRequest.getter(InvokeRequest::tenantId)).setter(InvokeRequest.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Tenant-Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, INVOCATION_TYPE_FIELD, LOG_TYPE_FIELD, CLIENT_CONTEXT_FIELD, DURABLE_EXECUTION_NAME_FIELD, PAYLOAD_FIELD, QUALIFIER_FIELD, TENANT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String invocationType;
    private final String logType;
    private final String clientContext;
    private final String durableExecutionName;
    private final SdkBytes payload;
    private final String qualifier;
    private final String tenantId;

    private InvokeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.durableExecutionName = builder.durableExecutionName;
        this.payload = builder.payload;
        this.qualifier = builder.qualifier;
        this.tenantId = builder.tenantId;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public final String invocationTypeAsString() {
        return this.invocationType;
    }

    public final LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public final String clientContext() {
        return this.clientContext;
    }

    public final String durableExecutionName() {
        return this.durableExecutionName;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString()) && Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.durableExecutionName(), other.durableExecutionName()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.tenantId(), other.tenantId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeRequest").add("FunctionName", (Object)this.functionName()).add("InvocationType", (Object)this.invocationTypeAsString()).add("LogType", (Object)this.logTypeAsString()).add("ClientContext", (Object)this.clientContext()).add("DurableExecutionName", (Object)this.durableExecutionName()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("Qualifier", (Object)this.qualifier()).add("TenantId", (Object)this.tenantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "InvocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
            case "DurableExecutionName": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionName()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("X-Amz-Invocation-Type", INVOCATION_TYPE_FIELD);
        map.put("X-Amz-Log-Type", LOG_TYPE_FIELD);
        map.put("X-Amz-Client-Context", CLIENT_CONTEXT_FIELD);
        map.put("X-Amz-Durable-Execution-Name", DURABLE_EXECUTION_NAME_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("X-Amz-Tenant-Id", TENANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeRequest, T> g) {
        return obj -> g.apply((InvokeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String invocationType;
        private String logType;
        private String clientContext;
        private String durableExecutionName;
        private SdkBytes payload;
        private String qualifier;
        private String tenantId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.invocationType(model.invocationType);
            this.logType(model.logType);
            this.clientContext(model.clientContext);
            this.durableExecutionName(model.durableExecutionName);
            this.payload(model.payload);
            this.qualifier(model.qualifier);
            this.tenantId(model.tenantId);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final String getDurableExecutionName() {
            return this.durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRequest build() {
            return new InvokeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeRequest> {
        public Builder functionName(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder clientContext(String var1);

        public Builder durableExecutionName(String var1);

        public Builder payload(SdkBytes var1);

        public Builder qualifier(String var1);

        public Builder tenantId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

