/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.DurableExecutionsCopier;
import software.amazon.awssdk.services.lambda.model.Execution;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDurableExecutionsByFunctionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListDurableExecutionsByFunctionResponse> {
    private static final SdkField<List<Execution>> DURABLE_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DurableExecutions").getter(ListDurableExecutionsByFunctionResponse.getter(ListDurableExecutionsByFunctionResponse::durableExecutions)).setter(ListDurableExecutionsByFunctionResponse.setter(Builder::durableExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Execution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListDurableExecutionsByFunctionResponse.getter(ListDurableExecutionsByFunctionResponse::nextMarker)).setter(ListDurableExecutionsByFunctionResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTIONS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDurableExecutionsByFunctionResponse.memberNameToFieldInitializer();
    private final List<Execution> durableExecutions;
    private final String nextMarker;

    private ListDurableExecutionsByFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.durableExecutions = builder.durableExecutions;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasDurableExecutions() {
        return this.durableExecutions != null && !(this.durableExecutions instanceof SdkAutoConstructList);
    }

    public final List<Execution> durableExecutions() {
        return this.durableExecutions;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDurableExecutions() ? this.durableExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDurableExecutionsByFunctionResponse)) {
            return false;
        }
        ListDurableExecutionsByFunctionResponse other = (ListDurableExecutionsByFunctionResponse)((Object)obj);
        return this.hasDurableExecutions() == other.hasDurableExecutions() && Objects.equals(this.durableExecutions(), other.durableExecutions()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListDurableExecutionsByFunctionResponse").add("DurableExecutions", this.hasDurableExecutions() ? this.durableExecutions() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurableExecutions": {
                return Optional.ofNullable(clazz.cast(this.durableExecutions()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DurableExecutions", DURABLE_EXECUTIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDurableExecutionsByFunctionResponse, T> g) {
        return obj -> g.apply((ListDurableExecutionsByFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<Execution> durableExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDurableExecutionsByFunctionResponse model) {
            super(model);
            this.durableExecutions(model.durableExecutions);
            this.nextMarker(model.nextMarker);
        }

        public final List<Execution.Builder> getDurableExecutions() {
            List<Execution.Builder> result = DurableExecutionsCopier.copyToBuilder(this.durableExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDurableExecutions(Collection<Execution.BuilderImpl> durableExecutions) {
            this.durableExecutions = DurableExecutionsCopier.copyFromBuilder(durableExecutions);
        }

        @Override
        public final Builder durableExecutions(Collection<Execution> durableExecutions) {
            this.durableExecutions = DurableExecutionsCopier.copy(durableExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durableExecutions(Execution ... durableExecutions) {
            this.durableExecutions(Arrays.asList(durableExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durableExecutions(Consumer<Execution.Builder> ... durableExecutions) {
            this.durableExecutions(Stream.of(durableExecutions).map(c -> (Execution)((Execution.Builder)Execution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDurableExecutionsByFunctionResponse build() {
            return new ListDurableExecutionsByFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDurableExecutionsByFunctionResponse> {
        public Builder durableExecutions(Collection<Execution> var1);

        public Builder durableExecutions(Execution ... var1);

        public Builder durableExecutions(Consumer<Execution.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

