/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventSourceMappingMetric {
    EVENT_COUNT("EventCount"),
    ERROR_COUNT("ErrorCount"),
    KAFKA_METRICS("KafkaMetrics"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventSourceMappingMetric> VALUE_MAP;
    private final String value;

    private EventSourceMappingMetric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventSourceMappingMetric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventSourceMappingMetric> knownValues() {
        EnumSet<EventSourceMappingMetric> knownValues = EnumSet.allOf(EventSourceMappingMetric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventSourceMappingMetric.class, EventSourceMappingMetric::toString);
    }
}

