/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;

public class ListVersionsByFunctionPublisher
implements SdkPublisher<ListVersionsByFunctionResponse> {
    private final LambdaAsyncClient client;
    private final ListVersionsByFunctionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVersionsByFunctionPublisher(LambdaAsyncClient client, ListVersionsByFunctionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVersionsByFunctionPublisher(LambdaAsyncClient client, ListVersionsByFunctionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVersionsByFunctionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVersionsByFunctionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionConfiguration> versions() {
        return this.flatMapIterable(response -> response.versions());
    }

    private class ListVersionsByFunctionResponseFetcher
    implements AsyncPageFetcher<ListVersionsByFunctionResponse> {
        private ListVersionsByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListVersionsByFunctionResponse> nextPage(ListVersionsByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsByFunctionPublisher.this.client.listVersionsByFunction(ListVersionsByFunctionPublisher.this.firstRequest);
            }
            return ListVersionsByFunctionPublisher.this.client.listVersionsByFunction((ListVersionsByFunctionRequest)((Object)ListVersionsByFunctionPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

