/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.Execution;
import software.amazon.awssdk.services.lambda.model.ListDurableExecutionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListDurableExecutionsByFunctionResponse;

public class ListDurableExecutionsByFunctionIterable
implements SdkIterable<ListDurableExecutionsByFunctionResponse> {
    private final LambdaClient client;
    private final ListDurableExecutionsByFunctionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDurableExecutionsByFunctionIterable(LambdaClient client, ListDurableExecutionsByFunctionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDurableExecutionsByFunctionResponseFetcher();
    }

    public Iterator<ListDurableExecutionsByFunctionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Execution> durableExecutions() {
        Function<ListDurableExecutionsByFunctionResponse, Iterator> getIterator = response -> {
            if (response != null && response.durableExecutions() != null) {
                return response.durableExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDurableExecutionsByFunctionResponseFetcher
    implements SyncPageFetcher<ListDurableExecutionsByFunctionResponse> {
        private ListDurableExecutionsByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListDurableExecutionsByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListDurableExecutionsByFunctionResponse nextPage(ListDurableExecutionsByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListDurableExecutionsByFunctionIterable.this.client.listDurableExecutionsByFunction(ListDurableExecutionsByFunctionIterable.this.firstRequest);
            }
            return ListDurableExecutionsByFunctionIterable.this.client.listDurableExecutionsByFunction((ListDurableExecutionsByFunctionRequest)((Object)ListDurableExecutionsByFunctionIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

