/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.Operation;
import software.amazon.awssdk.services.lambda.model.OperationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDurableExecutionStateResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetDurableExecutionStateResponse> {
    private static final SdkField<List<Operation>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(GetDurableExecutionStateResponse.getter(GetDurableExecutionStateResponse::operations)).setter(GetDurableExecutionStateResponse.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(GetDurableExecutionStateResponse.getter(GetDurableExecutionStateResponse::nextMarker)).setter(GetDurableExecutionStateResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDurableExecutionStateResponse.memberNameToFieldInitializer();
    private final List<Operation> operations;
    private final String nextMarker;

    private GetDurableExecutionStateResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<Operation> operations() {
        return this.operations;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionStateResponse)) {
            return false;
        }
        GetDurableExecutionStateResponse other = (GetDurableExecutionStateResponse)((Object)obj);
        return this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"GetDurableExecutionStateResponse").add("Operations", this.hasOperations() ? this.operations() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operations", OPERATIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionStateResponse, T> g) {
        return obj -> g.apply((GetDurableExecutionStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionStateResponse model) {
            super(model);
            this.operations(model.operations);
            this.nextMarker(model.nextMarker);
        }

        public final List<Operation.Builder> getOperations() {
            List<Operation.Builder> result = OperationsCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationsCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationsCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (Operation)((Operation.Builder)Operation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public GetDurableExecutionStateResponse build() {
            return new GetDurableExecutionStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDurableExecutionStateResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder operations(Consumer<Operation.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

