/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddLayerVersionPermissionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, AddLayerVersionPermissionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerName").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::layerName)).setter(AddLayerVersionPermissionRequest.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::versionNumber)).setter(AddLayerVersionPermissionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::statementId)).setter(AddLayerVersionPermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::action)).setter(AddLayerVersionPermissionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Principal").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::principal)).setter(AddLayerVersionPermissionRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::organizationId)).setter(AddLayerVersionPermissionRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(AddLayerVersionPermissionRequest.getter(AddLayerVersionPermissionRequest::revisionId)).setter(AddLayerVersionPermissionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD, VERSION_NUMBER_FIELD, STATEMENT_ID_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, ORGANIZATION_ID_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddLayerVersionPermissionRequest.memberNameToFieldInitializer();
    private final String layerName;
    private final Long versionNumber;
    private final String statementId;
    private final String action;
    private final String principal;
    private final String organizationId;
    private final String revisionId;

    private AddLayerVersionPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.versionNumber = builder.versionNumber;
        this.statementId = builder.statementId;
        this.action = builder.action;
        this.principal = builder.principal;
        this.organizationId = builder.organizationId;
        this.revisionId = builder.revisionId;
    }

    public final String layerName() {
        return this.layerName;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final String action() {
        return this.action;
    }

    public final String principal() {
        return this.principal;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddLayerVersionPermissionRequest)) {
            return false;
        }
        AddLayerVersionPermissionRequest other = (AddLayerVersionPermissionRequest)((Object)obj);
        return Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"AddLayerVersionPermissionRequest").add("LayerName", (Object)this.layerName()).add("VersionNumber", (Object)this.versionNumber()).add("StatementId", (Object)this.statementId()).add("Action", (Object)this.action()).add("Principal", (Object)this.principal()).add("OrganizationId", (Object)this.organizationId()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LayerName", LAYER_NAME_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("StatementId", STATEMENT_ID_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddLayerVersionPermissionRequest, T> g) {
        return obj -> g.apply((AddLayerVersionPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String layerName;
        private Long versionNumber;
        private String statementId;
        private String action;
        private String principal;
        private String organizationId;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddLayerVersionPermissionRequest model) {
            super(model);
            this.layerName(model.layerName);
            this.versionNumber(model.versionNumber);
            this.statementId(model.statementId);
            this.action(model.action);
            this.principal(model.principal);
            this.organizationId(model.organizationId);
            this.revisionId(model.revisionId);
        }

        public final String getLayerName() {
            return this.layerName;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddLayerVersionPermissionRequest build() {
            return new AddLayerVersionPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddLayerVersionPermissionRequest> {
        public Builder layerName(String var1);

        public Builder versionNumber(Long var1);

        public Builder statementId(String var1);

        public Builder action(String var1);

        public Builder principal(String var1);

        public Builder organizationId(String var1);

        public Builder revisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

