/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountUsage> {
    private static final SdkField<Long> TOTAL_CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCodeSize").getter(AccountUsage.getter(AccountUsage::totalCodeSize)).setter(AccountUsage.setter(Builder::totalCodeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCodeSize").build()}).build();
    private static final SdkField<Long> FUNCTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FunctionCount").getter(AccountUsage.getter(AccountUsage::functionCount)).setter(AccountUsage.setter(Builder::functionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_CODE_SIZE_FIELD, FUNCTION_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountUsage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long totalCodeSize;
    private final Long functionCount;

    private AccountUsage(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.functionCount = builder.functionCount;
    }

    public final Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public final Long functionCount() {
        return this.functionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountUsage)) {
            return false;
        }
        AccountUsage other = (AccountUsage)obj;
        return Objects.equals(this.totalCodeSize(), other.totalCodeSize()) && Objects.equals(this.functionCount(), other.functionCount());
    }

    public final String toString() {
        return ToString.builder((String)"AccountUsage").add("TotalCodeSize", (Object)this.totalCodeSize()).add("FunctionCount", (Object)this.functionCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCodeSize": {
                return Optional.ofNullable(clazz.cast(this.totalCodeSize()));
            }
            case "FunctionCount": {
                return Optional.ofNullable(clazz.cast(this.functionCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("TotalCodeSize", TOTAL_CODE_SIZE_FIELD);
        map.put("FunctionCount", FUNCTION_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountUsage, T> g) {
        return obj -> g.apply((AccountUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long functionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountUsage model) {
            this.totalCodeSize(model.totalCodeSize);
            this.functionCount(model.functionCount);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final Long getFunctionCount() {
            return this.functionCount;
        }

        public final void setFunctionCount(Long functionCount) {
            this.functionCount = functionCount;
        }

        @Override
        public final Builder functionCount(Long functionCount) {
            this.functionCount = functionCount;
            return this;
        }

        public AccountUsage build() {
            return new AccountUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountUsage> {
        public Builder totalCodeSize(Long var1);

        public Builder functionCount(Long var1);
    }
}

