/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the GetDurableExecutionHistory operation, containing the execution history and events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDurableExecutionHistoryResponse extends LambdaResponse implements
        ToCopyableBuilder<GetDurableExecutionHistoryResponse.Builder, GetDurableExecutionHistoryResponse> {
    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(GetDurableExecutionHistoryResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(GetDurableExecutionHistoryResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Event> events;

    private final String nextMarker;

    private GetDurableExecutionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set to
     * <code>true</code>. Each event represents a significant occurrence during the execution, such as step completion
     * or callback resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set to
     *         <code>true</code>. Each event represents a significant occurrence during the execution, such as step
     *         completion or callback resolution.
     */
    public final List<Event> events() {
        return events;
    }

    /**
     * <p>
     * If present, indicates that more history events are available. Use this value as the <code>Marker</code> parameter
     * in a subsequent request to retrieve the next page of results.
     * </p>
     * 
     * @return If present, indicates that more history events are available. Use this value as the <code>Marker</code>
     *         parameter in a subsequent request to retrieve the next page of results.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionHistoryResponse)) {
            return false;
        }
        GetDurableExecutionHistoryResponse other = (GetDurableExecutionHistoryResponse) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDurableExecutionHistoryResponse").add("Events", hasEvents() ? events() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Events", EVENTS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionHistoryResponse, T> g) {
        return obj -> g.apply((GetDurableExecutionHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDurableExecutionHistoryResponse> {
        /**
         * <p>
         * An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set to
         * <code>true</code>. Each event represents a significant occurrence during the execution, such as step
         * completion or callback resolution.
         * </p>
         * 
         * @param events
         *        An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set
         *        to <code>true</code>. Each event represents a significant occurrence during the execution, such as
         *        step completion or callback resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * <p>
         * An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set to
         * <code>true</code>. Each event represents a significant occurrence during the execution, such as step
         * completion or callback resolution.
         * </p>
         * 
         * @param events
         *        An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set
         *        to <code>true</code>. Each event represents a significant occurrence during the execution, such as
         *        step completion or callback resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * An array of execution history events, ordered chronologically unless <code>ReverseOrder</code> is set to
         * <code>true</code>. Each event represents a significant occurrence during the execution, such as step
         * completion or callback resolution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.Event.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.lambda.model.Event#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.Event.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<Event>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.Event.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<Event>)
         */
        Builder events(Consumer<Event.Builder>... events);

        /**
         * <p>
         * If present, indicates that more history events are available. Use this value as the <code>Marker</code>
         * parameter in a subsequent request to retrieve the next page of results.
         * </p>
         * 
         * @param nextMarker
         *        If present, indicates that more history events are available. Use this value as the
         *        <code>Marker</code> parameter in a subsequent request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionHistoryResponse model) {
            super(model);
            events(model.events);
            nextMarker(model.nextMarker);
        }

        public final List<Event.Builder> getEvents() {
            List<Event.Builder> result = EventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder>... events) {
            events(Stream.of(events).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public GetDurableExecutionHistoryResponse build() {
            return new GetDurableExecutionHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
