/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDurableExecutionHistoryRequest extends LambdaRequest implements
        ToCopyableBuilder<GetDurableExecutionHistoryRequest.Builder, GetDurableExecutionHistoryRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(GetDurableExecutionHistoryRequest::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()).build();

    private static final SdkField<Boolean> INCLUDE_EXECUTION_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeExecutionData").getter(getter(GetDurableExecutionHistoryRequest::includeExecutionData))
            .setter(setter(Builder::includeExecutionData))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeExecutionData").build())
            .build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(GetDurableExecutionHistoryRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetDurableExecutionHistoryRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReverseOrder").getter(getter(GetDurableExecutionHistoryRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ReverseOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            INCLUDE_EXECUTION_DATA_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD, REVERSE_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String durableExecutionArn;

    private final Boolean includeExecutionData;

    private final Integer maxItems;

    private final String marker;

    private final Boolean reverseOrder;

    private GetDurableExecutionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.includeExecutionData = builder.includeExecutionData;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * Specifies whether to include execution data such as step results and callback payloads in the history events. Set
     * to <code>true</code> to include data, or <code>false</code> to exclude it for a more compact response. The
     * default is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether to include execution data such as step results and callback payloads in the history
     *         events. Set to <code>true</code> to include data, or <code>false</code> to exclude it for a more compact
     *         response. The default is <code>true</code>.
     */
    public final Boolean includeExecutionData() {
        return includeExecutionData;
    }

    /**
     * <p>
     * The maximum number of history events to return per call. You can use <code>Marker</code> to retrieve additional
     * pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the default.
     * </p>
     * 
     * @return The maximum number of history events to return per call. You can use <code>Marker</code> to retrieve
     *         additional pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the
     *         default.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page of
     * results. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page
     *         of results. Each pagination token expires after 24 hours.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the history events in reverse chronological order (newest first). By
     * default, events are returned in chronological order (oldest first).
     * </p>
     * 
     * @return When set to <code>true</code>, returns the history events in reverse chronological order (newest first).
     *         By default, events are returned in chronological order (oldest first).
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(includeExecutionData());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionHistoryRequest)) {
            return false;
        }
        GetDurableExecutionHistoryRequest other = (GetDurableExecutionHistoryRequest) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn())
                && Objects.equals(includeExecutionData(), other.includeExecutionData())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker())
                && Objects.equals(reverseOrder(), other.reverseOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDurableExecutionHistoryRequest").add("DurableExecutionArn", durableExecutionArn())
                .add("IncludeExecutionData", includeExecutionData()).add("MaxItems", maxItems()).add("Marker", marker())
                .add("ReverseOrder", reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "IncludeExecutionData":
            return Optional.ofNullable(clazz.cast(includeExecutionData()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("IncludeExecutionData", INCLUDE_EXECUTION_DATA_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("ReverseOrder", REVERSE_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionHistoryRequest, T> g) {
        return obj -> g.apply((GetDurableExecutionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDurableExecutionHistoryRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * Specifies whether to include execution data such as step results and callback payloads in the history events.
         * Set to <code>true</code> to include data, or <code>false</code> to exclude it for a more compact response.
         * The default is <code>true</code>.
         * </p>
         * 
         * @param includeExecutionData
         *        Specifies whether to include execution data such as step results and callback payloads in the history
         *        events. Set to <code>true</code> to include data, or <code>false</code> to exclude it for a more
         *        compact response. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeExecutionData(Boolean includeExecutionData);

        /**
         * <p>
         * The maximum number of history events to return per call. You can use <code>Marker</code> to retrieve
         * additional pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the
         * default.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of history events to return per call. You can use <code>Marker</code> to retrieve
         *        additional pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page of
         * results. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param marker
         *        If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next
         *        page of results. Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * When set to <code>true</code>, returns the history events in reverse chronological order (newest first). By
         * default, events are returned in chronological order (oldest first).
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the history events in reverse chronological order (newest
         *        first). By default, events are returned in chronological order (oldest first).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String durableExecutionArn;

        private Boolean includeExecutionData;

        private Integer maxItems;

        private String marker;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionHistoryRequest model) {
            super(model);
            durableExecutionArn(model.durableExecutionArn);
            includeExecutionData(model.includeExecutionData);
            maxItems(model.maxItems);
            marker(model.marker);
            reverseOrder(model.reverseOrder);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final Boolean getIncludeExecutionData() {
            return includeExecutionData;
        }

        public final void setIncludeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
        }

        @Override
        public final Builder includeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDurableExecutionHistoryRequest build() {
            return new GetDurableExecutionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
