/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration that specifies the permissions required for the capacity provider to manage compute resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityProviderPermissionsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityProviderPermissionsConfig.Builder, CapacityProviderPermissionsConfig> {
    private static final SdkField<String> CAPACITY_PROVIDER_OPERATOR_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderOperatorRoleArn")
            .getter(getter(CapacityProviderPermissionsConfig::capacityProviderOperatorRoleArn))
            .setter(setter(Builder::capacityProviderOperatorRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderOperatorRoleArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CAPACITY_PROVIDER_OPERATOR_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityProviderOperatorRoleArn;

    private CapacityProviderPermissionsConfig(BuilderImpl builder) {
        this.capacityProviderOperatorRoleArn = builder.capacityProviderOperatorRoleArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that the capacity provider uses to manage compute instances and other Amazon Web Services
     * resources.
     * </p>
     * 
     * @return The ARN of the IAM role that the capacity provider uses to manage compute instances and other Amazon Web
     *         Services resources.
     */
    public final String capacityProviderOperatorRoleArn() {
        return capacityProviderOperatorRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderOperatorRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProviderPermissionsConfig)) {
            return false;
        }
        CapacityProviderPermissionsConfig other = (CapacityProviderPermissionsConfig) obj;
        return Objects.equals(capacityProviderOperatorRoleArn(), other.capacityProviderOperatorRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityProviderPermissionsConfig")
                .add("CapacityProviderOperatorRoleArn", capacityProviderOperatorRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderOperatorRoleArn":
            return Optional.ofNullable(clazz.cast(capacityProviderOperatorRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderOperatorRoleArn", CAPACITY_PROVIDER_OPERATOR_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityProviderPermissionsConfig, T> g) {
        return obj -> g.apply((CapacityProviderPermissionsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityProviderPermissionsConfig> {
        /**
         * <p>
         * The ARN of the IAM role that the capacity provider uses to manage compute instances and other Amazon Web
         * Services resources.
         * </p>
         * 
         * @param capacityProviderOperatorRoleArn
         *        The ARN of the IAM role that the capacity provider uses to manage compute instances and other Amazon
         *        Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderOperatorRoleArn(String capacityProviderOperatorRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String capacityProviderOperatorRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProviderPermissionsConfig model) {
            capacityProviderOperatorRoleArn(model.capacityProviderOperatorRoleArn);
        }

        public final String getCapacityProviderOperatorRoleArn() {
            return capacityProviderOperatorRoleArn;
        }

        public final void setCapacityProviderOperatorRoleArn(String capacityProviderOperatorRoleArn) {
            this.capacityProviderOperatorRoleArn = capacityProviderOperatorRoleArn;
        }

        @Override
        public final Builder capacityProviderOperatorRoleArn(String capacityProviderOperatorRoleArn) {
            this.capacityProviderOperatorRoleArn = capacityProviderOperatorRoleArn;
            return this;
        }

        @Override
        public CapacityProviderPermissionsConfig build() {
            return new CapacityProviderPermissionsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
