/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a callback operation that has started, including timing information and callback metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallbackStartedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CallbackStartedDetails.Builder, CallbackStartedDetails> {
    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallbackId").getter(getter(CallbackStartedDetails::callbackId)).setter(setter(Builder::callbackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackId").build()).build();

    private static final SdkField<Integer> HEARTBEAT_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HeartbeatTimeout").getter(getter(CallbackStartedDetails::heartbeatTimeout))
            .setter(setter(Builder::heartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatTimeout").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CallbackStartedDetails::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_ID_FIELD,
            HEARTBEAT_TIMEOUT_FIELD, TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String callbackId;

    private final Integer heartbeatTimeout;

    private final Integer timeout;

    private CallbackStartedDetails(BuilderImpl builder) {
        this.callbackId = builder.callbackId;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The callback ID. Callback IDs are generated by the <code>DurableContext</code> when a durable function calls
     * <code>ctx.waitForCallback</code>.
     * </p>
     * 
     * @return The callback ID. Callback IDs are generated by the <code>DurableContext</code> when a durable function
     *         calls <code>ctx.waitForCallback</code>.
     */
    public final String callbackId() {
        return callbackId;
    }

    /**
     * <p>
     * The heartbeat timeout value, in seconds.
     * </p>
     * 
     * @return The heartbeat timeout value, in seconds.
     */
    public final Integer heartbeatTimeout() {
        return heartbeatTimeout;
    }

    /**
     * <p>
     * The timeout value, in seconds.
     * </p>
     * 
     * @return The timeout value, in seconds.
     */
    public final Integer timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callbackId());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallbackStartedDetails)) {
            return false;
        }
        CallbackStartedDetails other = (CallbackStartedDetails) obj;
        return Objects.equals(callbackId(), other.callbackId()) && Objects.equals(heartbeatTimeout(), other.heartbeatTimeout())
                && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallbackStartedDetails").add("CallbackId", callbackId())
                .add("HeartbeatTimeout", heartbeatTimeout()).add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallbackId":
            return Optional.ofNullable(clazz.cast(callbackId()));
        case "HeartbeatTimeout":
            return Optional.ofNullable(clazz.cast(heartbeatTimeout()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CallbackId", CALLBACK_ID_FIELD);
        map.put("HeartbeatTimeout", HEARTBEAT_TIMEOUT_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallbackStartedDetails, T> g) {
        return obj -> g.apply((CallbackStartedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallbackStartedDetails> {
        /**
         * <p>
         * The callback ID. Callback IDs are generated by the <code>DurableContext</code> when a durable function calls
         * <code>ctx.waitForCallback</code>.
         * </p>
         * 
         * @param callbackId
         *        The callback ID. Callback IDs are generated by the <code>DurableContext</code> when a durable function
         *        calls <code>ctx.waitForCallback</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackId(String callbackId);

        /**
         * <p>
         * The heartbeat timeout value, in seconds.
         * </p>
         * 
         * @param heartbeatTimeout
         *        The heartbeat timeout value, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(Integer heartbeatTimeout);

        /**
         * <p>
         * The timeout value, in seconds.
         * </p>
         * 
         * @param timeout
         *        The timeout value, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);
    }

    static final class BuilderImpl implements Builder {
        private String callbackId;

        private Integer heartbeatTimeout;

        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CallbackStartedDetails model) {
            callbackId(model.callbackId);
            heartbeatTimeout(model.heartbeatTimeout);
            timeout(model.timeout);
        }

        public final String getCallbackId() {
            return callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Integer getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public CallbackStartedDetails build() {
            return new CallbackStartedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
