/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.CapacityProvider;
import software.amazon.awssdk.services.lambda.model.ListCapacityProvidersRequest;
import software.amazon.awssdk.services.lambda.model.ListCapacityProvidersResponse;

public class ListCapacityProvidersIterable
implements SdkIterable<ListCapacityProvidersResponse> {
    private final LambdaClient client;
    private final ListCapacityProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCapacityProvidersIterable(LambdaClient client, ListCapacityProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCapacityProvidersResponseFetcher();
    }

    public Iterator<ListCapacityProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityProvider> capacityProviders() {
        Function<ListCapacityProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityProviders() != null) {
                return response.capacityProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCapacityProvidersResponseFetcher
    implements SyncPageFetcher<ListCapacityProvidersResponse> {
        private ListCapacityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListCapacityProvidersResponse nextPage(ListCapacityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityProvidersIterable.this.client.listCapacityProviders(ListCapacityProvidersIterable.this.firstRequest);
            }
            return ListCapacityProvidersIterable.this.client.listCapacityProviders((ListCapacityProvidersRequest)((Object)ListCapacityProvidersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

