/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.ErrorObject;
import software.amazon.awssdk.services.lambda.model.ExecutionStatus;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.TraceHeader;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDurableExecutionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetDurableExecutionResponse> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionArn").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::durableExecutionArn)).setter(GetDurableExecutionResponse.setter(Builder::durableExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionArn").build()}).build();
    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionName").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::durableExecutionName)).setter(GetDurableExecutionResponse.setter(Builder::durableExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionName").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::functionArn)).setter(GetDurableExecutionResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> INPUT_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputPayload").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::inputPayload)).setter(GetDurableExecutionResponse.setter(Builder::inputPayload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputPayload").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Result").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::result)).setter(GetDurableExecutionResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::error)).setter(GetDurableExecutionResponse.setter(Builder::error)).constructor(ErrorObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::startTimestamp)).setter(GetDurableExecutionResponse.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::statusAsString)).setter(GetDurableExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::endTimestamp)).setter(GetDurableExecutionResponse.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::version)).setter(GetDurableExecutionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<TraceHeader> TRACE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TraceHeader").getter(GetDurableExecutionResponse.getter(GetDurableExecutionResponse::traceHeader)).setter(GetDurableExecutionResponse.setter(Builder::traceHeader)).constructor(TraceHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD, DURABLE_EXECUTION_NAME_FIELD, FUNCTION_ARN_FIELD, INPUT_PAYLOAD_FIELD, RESULT_FIELD, ERROR_FIELD, START_TIMESTAMP_FIELD, STATUS_FIELD, END_TIMESTAMP_FIELD, VERSION_FIELD, TRACE_HEADER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDurableExecutionResponse.memberNameToFieldInitializer();
    private final String durableExecutionArn;
    private final String durableExecutionName;
    private final String functionArn;
    private final String inputPayload;
    private final String result;
    private final ErrorObject error;
    private final Instant startTimestamp;
    private final String status;
    private final Instant endTimestamp;
    private final String version;
    private final TraceHeader traceHeader;

    private GetDurableExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.durableExecutionName = builder.durableExecutionName;
        this.functionArn = builder.functionArn;
        this.inputPayload = builder.inputPayload;
        this.result = builder.result;
        this.error = builder.error;
        this.startTimestamp = builder.startTimestamp;
        this.status = builder.status;
        this.endTimestamp = builder.endTimestamp;
        this.version = builder.version;
        this.traceHeader = builder.traceHeader;
    }

    public final String durableExecutionArn() {
        return this.durableExecutionArn;
    }

    public final String durableExecutionName() {
        return this.durableExecutionName;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final String inputPayload() {
        return this.inputPayload;
    }

    public final String result() {
        return this.result;
    }

    public final ErrorObject error() {
        return this.error;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final String version() {
        return this.version;
    }

    public final TraceHeader traceHeader() {
        return this.traceHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceHeader());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionResponse)) {
            return false;
        }
        GetDurableExecutionResponse other = (GetDurableExecutionResponse)((Object)obj);
        return Objects.equals(this.durableExecutionArn(), other.durableExecutionArn()) && Objects.equals(this.durableExecutionName(), other.durableExecutionName()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.inputPayload(), other.inputPayload()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.traceHeader(), other.traceHeader());
    }

    public final String toString() {
        return ToString.builder((String)"GetDurableExecutionResponse").add("DurableExecutionArn", (Object)this.durableExecutionArn()).add("DurableExecutionName", (Object)this.durableExecutionName()).add("FunctionArn", (Object)this.functionArn()).add("InputPayload", (Object)(this.inputPayload() == null ? null : "*** Sensitive Data Redacted ***")).add("Result", (Object)(this.result() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)this.error()).add("StartTimestamp", (Object)this.startTimestamp()).add("Status", (Object)this.statusAsString()).add("EndTimestamp", (Object)this.endTimestamp()).add("Version", (Object)this.version()).add("TraceHeader", (Object)this.traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurableExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionArn()));
            }
            case "DurableExecutionName": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionName()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "InputPayload": {
                return Optional.ofNullable(clazz.cast(this.inputPayload()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "TraceHeader": {
                return Optional.ofNullable(clazz.cast(this.traceHeader()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("InputPayload", INPUT_PAYLOAD_FIELD);
        map.put("Result", RESULT_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("TraceHeader", TRACE_HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionResponse, T> g) {
        return obj -> g.apply((GetDurableExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String durableExecutionArn;
        private String durableExecutionName;
        private String functionArn;
        private String inputPayload;
        private String result;
        private ErrorObject error;
        private Instant startTimestamp;
        private String status;
        private Instant endTimestamp;
        private String version;
        private TraceHeader traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionResponse model) {
            super(model);
            this.durableExecutionArn(model.durableExecutionArn);
            this.durableExecutionName(model.durableExecutionName);
            this.functionArn(model.functionArn);
            this.inputPayload(model.inputPayload);
            this.result(model.result);
            this.error(model.error);
            this.startTimestamp(model.startTimestamp);
            this.status(model.status);
            this.endTimestamp(model.endTimestamp);
            this.version(model.version);
            this.traceHeader(model.traceHeader);
        }

        public final String getDurableExecutionArn() {
            return this.durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getDurableExecutionName() {
            return this.durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getInputPayload() {
            return this.inputPayload;
        }

        public final void setInputPayload(String inputPayload) {
            this.inputPayload = inputPayload;
        }

        @Override
        public final Builder inputPayload(String inputPayload) {
            this.inputPayload = inputPayload;
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final TraceHeader.Builder getTraceHeader() {
            return this.traceHeader != null ? this.traceHeader.toBuilder() : null;
        }

        public final void setTraceHeader(TraceHeader.BuilderImpl traceHeader) {
            this.traceHeader = traceHeader != null ? traceHeader.build() : null;
        }

        @Override
        public final Builder traceHeader(TraceHeader traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        @Override
        public GetDurableExecutionResponse build() {
            return new GetDurableExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDurableExecutionResponse> {
        public Builder durableExecutionArn(String var1);

        public Builder durableExecutionName(String var1);

        public Builder functionArn(String var1);

        public Builder inputPayload(String var1);

        public Builder result(String var1);

        public Builder error(ErrorObject var1);

        default public Builder error(Consumer<ErrorObject.Builder> error) {
            return this.error((ErrorObject)((ErrorObject.Builder)ErrorObject.builder().applyMutation(error)).build());
        }

        public Builder startTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder endTimestamp(Instant var1);

        public Builder version(String var1);

        public Builder traceHeader(TraceHeader var1);

        default public Builder traceHeader(Consumer<TraceHeader.Builder> traceHeader) {
            return this.traceHeader((TraceHeader)((TraceHeader.Builder)TraceHeader.builder().applyMutation(traceHeader)).build());
        }
    }
}

