/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an operation within a durable execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Operation implements SdkPojo, Serializable, ToCopyableBuilder<Operation.Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Operation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(Operation::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Operation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Operation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubType").getter(getter(Operation::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(Operation::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(Operation::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Operation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("ExecutionDetails")
            .getter(getter(Operation::executionDetails)).setter(setter(Builder::executionDetails))
            .constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionDetails").build()).build();

    private static final SdkField<ContextDetails> CONTEXT_DETAILS_FIELD = SdkField
            .<ContextDetails> builder(MarshallingType.SDK_POJO).memberName("ContextDetails")
            .getter(getter(Operation::contextDetails)).setter(setter(Builder::contextDetails))
            .constructor(ContextDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextDetails").build()).build();

    private static final SdkField<StepDetails> STEP_DETAILS_FIELD = SdkField.<StepDetails> builder(MarshallingType.SDK_POJO)
            .memberName("StepDetails").getter(getter(Operation::stepDetails)).setter(setter(Builder::stepDetails))
            .constructor(StepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDetails").build()).build();

    private static final SdkField<WaitDetails> WAIT_DETAILS_FIELD = SdkField.<WaitDetails> builder(MarshallingType.SDK_POJO)
            .memberName("WaitDetails").getter(getter(Operation::waitDetails)).setter(setter(Builder::waitDetails))
            .constructor(WaitDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitDetails").build()).build();

    private static final SdkField<CallbackDetails> CALLBACK_DETAILS_FIELD = SdkField
            .<CallbackDetails> builder(MarshallingType.SDK_POJO).memberName("CallbackDetails")
            .getter(getter(Operation::callbackDetails)).setter(setter(Builder::callbackDetails))
            .constructor(CallbackDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackDetails").build()).build();

    private static final SdkField<ChainedInvokeDetails> CHAINED_INVOKE_DETAILS_FIELD = SdkField
            .<ChainedInvokeDetails> builder(MarshallingType.SDK_POJO).memberName("ChainedInvokeDetails")
            .getter(getter(Operation::chainedInvokeDetails)).setter(setter(Builder::chainedInvokeDetails))
            .constructor(ChainedInvokeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARENT_ID_FIELD,
            NAME_FIELD, TYPE_FIELD, SUB_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, STATUS_FIELD,
            EXECUTION_DETAILS_FIELD, CONTEXT_DETAILS_FIELD, STEP_DETAILS_FIELD, WAIT_DETAILS_FIELD, CALLBACK_DETAILS_FIELD,
            CHAINED_INVOKE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String parentId;

    private final String name;

    private final String type;

    private final String subType;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final String status;

    private final ExecutionDetails executionDetails;

    private final ContextDetails contextDetails;

    private final StepDetails stepDetails;

    private final WaitDetails waitDetails;

    private final CallbackDetails callbackDetails;

    private final ChainedInvokeDetails chainedInvokeDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.status = builder.status;
        this.executionDetails = builder.executionDetails;
        this.contextDetails = builder.contextDetails;
        this.stepDetails = builder.stepDetails;
        this.waitDetails = builder.waitDetails;
        this.callbackDetails = builder.callbackDetails;
        this.chainedInvokeDetails = builder.chainedInvokeDetails;
    }

    /**
     * <p>
     * The unique identifier for this operation.
     * </p>
     * 
     * @return The unique identifier for this operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier of the parent operation, if this operation is running within a child context.
     * </p>
     * 
     * @return The unique identifier of the parent operation, if this operation is running within a child context.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * The customer-provided name for this operation.
     * </p>
     * 
     * @return The customer-provided name for this operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The subtype of the operation, providing additional categorization.
     * </p>
     * 
     * @return The subtype of the operation, providing additional categorization.
     */
    public final String subType() {
        return subType;
    }

    /**
     * <p>
     * The date and time when the operation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the operation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The date and time when the operation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the operation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * The current status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the operation.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the operation.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details about the execution, if this operation represents an execution.
     * </p>
     * 
     * @return Details about the execution, if this operation represents an execution.
     */
    public final ExecutionDetails executionDetails() {
        return executionDetails;
    }

    /**
     * <p>
     * Details about the context, if this operation represents a context.
     * </p>
     * 
     * @return Details about the context, if this operation represents a context.
     */
    public final ContextDetails contextDetails() {
        return contextDetails;
    }

    /**
     * <p>
     * Details about the step, if this operation represents a step.
     * </p>
     * 
     * @return Details about the step, if this operation represents a step.
     */
    public final StepDetails stepDetails() {
        return stepDetails;
    }

    /**
     * <p>
     * Details about the wait operation, if this operation represents a wait.
     * </p>
     * 
     * @return Details about the wait operation, if this operation represents a wait.
     */
    public final WaitDetails waitDetails() {
        return waitDetails;
    }

    /**
     * Returns the value of the CallbackDetails property for this object.
     * 
     * @return The value of the CallbackDetails property for this object.
     */
    public final CallbackDetails callbackDetails() {
        return callbackDetails;
    }

    /**
     * Returns the value of the ChainedInvokeDetails property for this object.
     * 
     * @return The value of the ChainedInvokeDetails property for this object.
     */
    public final ChainedInvokeDetails chainedInvokeDetails() {
        return chainedInvokeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(contextDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(waitDetails());
        hashCode = 31 * hashCode + Objects.hashCode(callbackDetails());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(parentId(), other.parentId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(subType(), other.subType()) && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(executionDetails(), other.executionDetails())
                && Objects.equals(contextDetails(), other.contextDetails()) && Objects.equals(stepDetails(), other.stepDetails())
                && Objects.equals(waitDetails(), other.waitDetails())
                && Objects.equals(callbackDetails(), other.callbackDetails())
                && Objects.equals(chainedInvokeDetails(), other.chainedInvokeDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Operation").add("Id", id()).add("ParentId", parentId()).add("Name", name())
                .add("Type", typeAsString()).add("SubType", subType()).add("StartTimestamp", startTimestamp())
                .add("EndTimestamp", endTimestamp()).add("Status", statusAsString()).add("ExecutionDetails", executionDetails())
                .add("ContextDetails", contextDetails()).add("StepDetails", stepDetails()).add("WaitDetails", waitDetails())
                .add("CallbackDetails", callbackDetails()).add("ChainedInvokeDetails", chainedInvokeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subType()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ExecutionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        case "ContextDetails":
            return Optional.ofNullable(clazz.cast(contextDetails()));
        case "StepDetails":
            return Optional.ofNullable(clazz.cast(stepDetails()));
        case "WaitDetails":
            return Optional.ofNullable(clazz.cast(waitDetails()));
        case "CallbackDetails":
            return Optional.ofNullable(clazz.cast(callbackDetails()));
        case "ChainedInvokeDetails":
            return Optional.ofNullable(clazz.cast(chainedInvokeDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ExecutionDetails", EXECUTION_DETAILS_FIELD);
        map.put("ContextDetails", CONTEXT_DETAILS_FIELD);
        map.put("StepDetails", STEP_DETAILS_FIELD);
        map.put("WaitDetails", WAIT_DETAILS_FIELD);
        map.put("CallbackDetails", CALLBACK_DETAILS_FIELD);
        map.put("ChainedInvokeDetails", CHAINED_INVOKE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The unique identifier for this operation.
         * </p>
         * 
         * @param id
         *        The unique identifier for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier of the parent operation, if this operation is running within a child context.
         * </p>
         * 
         * @param parentId
         *        The unique identifier of the parent operation, if this operation is running within a child context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * The customer-provided name for this operation.
         * </p>
         * 
         * @param name
         *        The customer-provided name for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param type
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param type
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The subtype of the operation, providing additional categorization.
         * </p>
         * 
         * @param subType
         *        The subtype of the operation, providing additional categorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(String subType);

        /**
         * <p>
         * The date and time when the operation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param startTimestamp
         *        The date and time when the operation started, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The date and time when the operation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param endTimestamp
         *        The date and time when the operation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         *        format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The current status of the operation.
         * </p>
         * 
         * @param status
         *        The current status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the operation.
         * </p>
         * 
         * @param status
         *        The current status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Details about the execution, if this operation represents an execution.
         * </p>
         * 
         * @param executionDetails
         *        Details about the execution, if this operation represents an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(ExecutionDetails executionDetails);

        /**
         * <p>
         * Details about the execution, if this operation represents an execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionDetails.Builder} avoiding the
         * need to create one manually via {@link ExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #executionDetails(ExecutionDetails)}.
         * 
         * @param executionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionDetails(ExecutionDetails)
         */
        default Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return executionDetails(ExecutionDetails.builder().applyMutation(executionDetails).build());
        }

        /**
         * <p>
         * Details about the context, if this operation represents a context.
         * </p>
         * 
         * @param contextDetails
         *        Details about the context, if this operation represents a context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextDetails(ContextDetails contextDetails);

        /**
         * <p>
         * Details about the context, if this operation represents a context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextDetails.Builder} avoiding the need
         * to create one manually via {@link ContextDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #contextDetails(ContextDetails)}.
         * 
         * @param contextDetails
         *        a consumer that will call methods on {@link ContextDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextDetails(ContextDetails)
         */
        default Builder contextDetails(Consumer<ContextDetails.Builder> contextDetails) {
            return contextDetails(ContextDetails.builder().applyMutation(contextDetails).build());
        }

        /**
         * <p>
         * Details about the step, if this operation represents a step.
         * </p>
         * 
         * @param stepDetails
         *        Details about the step, if this operation represents a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(StepDetails stepDetails);

        /**
         * <p>
         * Details about the step, if this operation represents a step.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepDetails.Builder} avoiding the need to
         * create one manually via {@link StepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #stepDetails(StepDetails)}.
         * 
         * @param stepDetails
         *        a consumer that will call methods on {@link StepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepDetails(StepDetails)
         */
        default Builder stepDetails(Consumer<StepDetails.Builder> stepDetails) {
            return stepDetails(StepDetails.builder().applyMutation(stepDetails).build());
        }

        /**
         * <p>
         * Details about the wait operation, if this operation represents a wait.
         * </p>
         * 
         * @param waitDetails
         *        Details about the wait operation, if this operation represents a wait.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitDetails(WaitDetails waitDetails);

        /**
         * <p>
         * Details about the wait operation, if this operation represents a wait.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitDetails.Builder} avoiding the need to
         * create one manually via {@link WaitDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #waitDetails(WaitDetails)}.
         * 
         * @param waitDetails
         *        a consumer that will call methods on {@link WaitDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitDetails(WaitDetails)
         */
        default Builder waitDetails(Consumer<WaitDetails.Builder> waitDetails) {
            return waitDetails(WaitDetails.builder().applyMutation(waitDetails).build());
        }

        /**
         * Sets the value of the CallbackDetails property for this object.
         *
         * @param callbackDetails
         *        The new value for the CallbackDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackDetails(CallbackDetails callbackDetails);

        /**
         * Sets the value of the CallbackDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackDetails.Builder} avoiding the
         * need to create one manually via {@link CallbackDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #callbackDetails(CallbackDetails)}.
         * 
         * @param callbackDetails
         *        a consumer that will call methods on {@link CallbackDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackDetails(CallbackDetails)
         */
        default Builder callbackDetails(Consumer<CallbackDetails.Builder> callbackDetails) {
            return callbackDetails(CallbackDetails.builder().applyMutation(callbackDetails).build());
        }

        /**
         * Sets the value of the ChainedInvokeDetails property for this object.
         *
         * @param chainedInvokeDetails
         *        The new value for the ChainedInvokeDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeDetails(ChainedInvokeDetails chainedInvokeDetails);

        /**
         * Sets the value of the ChainedInvokeDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChainedInvokeDetails.Builder} avoiding
         * the need to create one manually via {@link ChainedInvokeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #chainedInvokeDetails(ChainedInvokeDetails)}.
         * 
         * @param chainedInvokeDetails
         *        a consumer that will call methods on {@link ChainedInvokeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeDetails(ChainedInvokeDetails)
         */
        default Builder chainedInvokeDetails(Consumer<ChainedInvokeDetails.Builder> chainedInvokeDetails) {
            return chainedInvokeDetails(ChainedInvokeDetails.builder().applyMutation(chainedInvokeDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String parentId;

        private String name;

        private String type;

        private String subType;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private String status;

        private ExecutionDetails executionDetails;

        private ContextDetails contextDetails;

        private StepDetails stepDetails;

        private WaitDetails waitDetails;

        private CallbackDetails callbackDetails;

        private ChainedInvokeDetails chainedInvokeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            id(model.id);
            parentId(model.parentId);
            name(model.name);
            type(model.type);
            subType(model.subType);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            status(model.status);
            executionDetails(model.executionDetails);
            contextDetails(model.contextDetails);
            stepDetails(model.stepDetails);
            waitDetails(model.waitDetails);
            callbackDetails(model.callbackDetails);
            chainedInvokeDetails(model.chainedInvokeDetails);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return executionDetails != null ? executionDetails.toBuilder() : null;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final ContextDetails.Builder getContextDetails() {
            return contextDetails != null ? contextDetails.toBuilder() : null;
        }

        public final void setContextDetails(ContextDetails.BuilderImpl contextDetails) {
            this.contextDetails = contextDetails != null ? contextDetails.build() : null;
        }

        @Override
        public final Builder contextDetails(ContextDetails contextDetails) {
            this.contextDetails = contextDetails;
            return this;
        }

        public final StepDetails.Builder getStepDetails() {
            return stepDetails != null ? stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetails.BuilderImpl stepDetails) {
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
        }

        @Override
        public final Builder stepDetails(StepDetails stepDetails) {
            this.stepDetails = stepDetails;
            return this;
        }

        public final WaitDetails.Builder getWaitDetails() {
            return waitDetails != null ? waitDetails.toBuilder() : null;
        }

        public final void setWaitDetails(WaitDetails.BuilderImpl waitDetails) {
            this.waitDetails = waitDetails != null ? waitDetails.build() : null;
        }

        @Override
        public final Builder waitDetails(WaitDetails waitDetails) {
            this.waitDetails = waitDetails;
            return this;
        }

        public final CallbackDetails.Builder getCallbackDetails() {
            return callbackDetails != null ? callbackDetails.toBuilder() : null;
        }

        public final void setCallbackDetails(CallbackDetails.BuilderImpl callbackDetails) {
            this.callbackDetails = callbackDetails != null ? callbackDetails.build() : null;
        }

        @Override
        public final Builder callbackDetails(CallbackDetails callbackDetails) {
            this.callbackDetails = callbackDetails;
            return this;
        }

        public final ChainedInvokeDetails.Builder getChainedInvokeDetails() {
            return chainedInvokeDetails != null ? chainedInvokeDetails.toBuilder() : null;
        }

        public final void setChainedInvokeDetails(ChainedInvokeDetails.BuilderImpl chainedInvokeDetails) {
            this.chainedInvokeDetails = chainedInvokeDetails != null ? chainedInvokeDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeDetails(ChainedInvokeDetails chainedInvokeDetails) {
            this.chainedInvokeDetails = chainedInvokeDetails;
            return this;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
