/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for a step operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepOptions implements SdkPojo, Serializable, ToCopyableBuilder<StepOptions.Builder, StepOptions> {
    private static final SdkField<Integer> NEXT_ATTEMPT_DELAY_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NextAttemptDelaySeconds").getter(getter(StepOptions::nextAttemptDelaySeconds))
            .setter(setter(Builder::nextAttemptDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextAttemptDelaySeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_ATTEMPT_DELAY_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer nextAttemptDelaySeconds;

    private StepOptions(BuilderImpl builder) {
        this.nextAttemptDelaySeconds = builder.nextAttemptDelaySeconds;
    }

    /**
     * <p>
     * The delay in seconds before the next retry attempt.
     * </p>
     * 
     * @return The delay in seconds before the next retry attempt.
     */
    public final Integer nextAttemptDelaySeconds() {
        return nextAttemptDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextAttemptDelaySeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepOptions)) {
            return false;
        }
        StepOptions other = (StepOptions) obj;
        return Objects.equals(nextAttemptDelaySeconds(), other.nextAttemptDelaySeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepOptions").add("NextAttemptDelaySeconds", nextAttemptDelaySeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextAttemptDelaySeconds":
            return Optional.ofNullable(clazz.cast(nextAttemptDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextAttemptDelaySeconds", NEXT_ATTEMPT_DELAY_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepOptions, T> g) {
        return obj -> g.apply((StepOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepOptions> {
        /**
         * <p>
         * The delay in seconds before the next retry attempt.
         * </p>
         * 
         * @param nextAttemptDelaySeconds
         *        The delay in seconds before the next retry attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextAttemptDelaySeconds(Integer nextAttemptDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer nextAttemptDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(StepOptions model) {
            nextAttemptDelaySeconds(model.nextAttemptDelaySeconds);
        }

        public final Integer getNextAttemptDelaySeconds() {
            return nextAttemptDelaySeconds;
        }

        public final void setNextAttemptDelaySeconds(Integer nextAttemptDelaySeconds) {
            this.nextAttemptDelaySeconds = nextAttemptDelaySeconds;
        }

        @Override
        public final Builder nextAttemptDelaySeconds(Integer nextAttemptDelaySeconds) {
            this.nextAttemptDelaySeconds = nextAttemptDelaySeconds;
            return this;
        }

        @Override
        public StepOptions build() {
            return new StepOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
