/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDurableExecutionCallbackSuccessRequest extends LambdaRequest implements
        ToCopyableBuilder<SendDurableExecutionCallbackSuccessRequest.Builder, SendDurableExecutionCallbackSuccessRequest> {
    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallbackId").getter(getter(SendDurableExecutionCallbackSuccessRequest::callbackId))
            .setter(setter(Builder::callbackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CallbackId").build()).build();

    private static final SdkField<SdkBytes> RESULT_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Result")
            .getter(getter(SendDurableExecutionCallbackSuccessRequest::result))
            .setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_ID_FIELD,
            RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String callbackId;

    private final SdkBytes result;

    private SendDurableExecutionCallbackSuccessRequest(BuilderImpl builder) {
        super(builder);
        this.callbackId = builder.callbackId;
        this.result = builder.result;
    }

    /**
     * <p>
     * The unique identifier for the callback operation.
     * </p>
     * 
     * @return The unique identifier for the callback operation.
     */
    public final String callbackId() {
        return callbackId;
    }

    /**
     * <p>
     * The result data from the successful callback operation. Maximum size is 256 KB.
     * </p>
     * 
     * @return The result data from the successful callback operation. Maximum size is 256 KB.
     */
    public final SdkBytes result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callbackId());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDurableExecutionCallbackSuccessRequest)) {
            return false;
        }
        SendDurableExecutionCallbackSuccessRequest other = (SendDurableExecutionCallbackSuccessRequest) obj;
        return Objects.equals(callbackId(), other.callbackId()) && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendDurableExecutionCallbackSuccessRequest").add("CallbackId", callbackId())
                .add("Result", result() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallbackId":
            return Optional.ofNullable(clazz.cast(callbackId()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CallbackId", CALLBACK_ID_FIELD);
        map.put("Result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendDurableExecutionCallbackSuccessRequest, T> g) {
        return obj -> g.apply((SendDurableExecutionCallbackSuccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendDurableExecutionCallbackSuccessRequest> {
        /**
         * <p>
         * The unique identifier for the callback operation.
         * </p>
         * 
         * @param callbackId
         *        The unique identifier for the callback operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackId(String callbackId);

        /**
         * <p>
         * The result data from the successful callback operation. Maximum size is 256 KB.
         * </p>
         * 
         * @param result
         *        The result data from the successful callback operation. Maximum size is 256 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(SdkBytes result);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String callbackId;

        private SdkBytes result;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDurableExecutionCallbackSuccessRequest model) {
            super(model);
            callbackId(model.callbackId);
            result(model.result);
        }

        public final String getCallbackId() {
            return callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final ByteBuffer getResult() {
            return result == null ? null : result.asByteBuffer();
        }

        public final void setResult(ByteBuffer result) {
            result(result == null ? null : SdkBytes.fromByteBuffer(result));
        }

        @Override
        public final Builder result(SdkBytes result) {
            this.result = result;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDurableExecutionCallbackSuccessRequest build() {
            return new SendDurableExecutionCallbackSuccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
