/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An update to be applied to an operation during checkpointing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationUpdate implements SdkPojo, Serializable, ToCopyableBuilder<OperationUpdate.Builder, OperationUpdate> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(OperationUpdate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(OperationUpdate::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OperationUpdate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OperationUpdate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubType").getter(getter(OperationUpdate::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(OperationUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Payload")
            .getter(getter(OperationUpdate::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField.<ErrorObject> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(OperationUpdate::error)).setter(setter(Builder::error))
            .constructor(ErrorObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<ContextOptions> CONTEXT_OPTIONS_FIELD = SdkField
            .<ContextOptions> builder(MarshallingType.SDK_POJO).memberName("ContextOptions")
            .getter(getter(OperationUpdate::contextOptions)).setter(setter(Builder::contextOptions))
            .constructor(ContextOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextOptions").build()).build();

    private static final SdkField<StepOptions> STEP_OPTIONS_FIELD = SdkField.<StepOptions> builder(MarshallingType.SDK_POJO)
            .memberName("StepOptions").getter(getter(OperationUpdate::stepOptions)).setter(setter(Builder::stepOptions))
            .constructor(StepOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepOptions").build()).build();

    private static final SdkField<WaitOptions> WAIT_OPTIONS_FIELD = SdkField.<WaitOptions> builder(MarshallingType.SDK_POJO)
            .memberName("WaitOptions").getter(getter(OperationUpdate::waitOptions)).setter(setter(Builder::waitOptions))
            .constructor(WaitOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitOptions").build()).build();

    private static final SdkField<CallbackOptions> CALLBACK_OPTIONS_FIELD = SdkField
            .<CallbackOptions> builder(MarshallingType.SDK_POJO).memberName("CallbackOptions")
            .getter(getter(OperationUpdate::callbackOptions)).setter(setter(Builder::callbackOptions))
            .constructor(CallbackOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackOptions").build()).build();

    private static final SdkField<ChainedInvokeOptions> CHAINED_INVOKE_OPTIONS_FIELD = SdkField
            .<ChainedInvokeOptions> builder(MarshallingType.SDK_POJO).memberName("ChainedInvokeOptions")
            .getter(getter(OperationUpdate::chainedInvokeOptions)).setter(setter(Builder::chainedInvokeOptions))
            .constructor(ChainedInvokeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARENT_ID_FIELD,
            NAME_FIELD, TYPE_FIELD, SUB_TYPE_FIELD, ACTION_FIELD, PAYLOAD_FIELD, ERROR_FIELD, CONTEXT_OPTIONS_FIELD,
            STEP_OPTIONS_FIELD, WAIT_OPTIONS_FIELD, CALLBACK_OPTIONS_FIELD, CHAINED_INVOKE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String parentId;

    private final String name;

    private final String type;

    private final String subType;

    private final String action;

    private final String payload;

    private final ErrorObject error;

    private final ContextOptions contextOptions;

    private final StepOptions stepOptions;

    private final WaitOptions waitOptions;

    private final CallbackOptions callbackOptions;

    private final ChainedInvokeOptions chainedInvokeOptions;

    private OperationUpdate(BuilderImpl builder) {
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
        this.action = builder.action;
        this.payload = builder.payload;
        this.error = builder.error;
        this.contextOptions = builder.contextOptions;
        this.stepOptions = builder.stepOptions;
        this.waitOptions = builder.waitOptions;
        this.callbackOptions = builder.callbackOptions;
        this.chainedInvokeOptions = builder.chainedInvokeOptions;
    }

    /**
     * <p>
     * The unique identifier for this operation.
     * </p>
     * 
     * @return The unique identifier for this operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier of the parent operation, if this operation is running within a child context.
     * </p>
     * 
     * @return The unique identifier of the parent operation, if this operation is running within a child context.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * The customer-provided name for this operation.
     * </p>
     * 
     * @return The customer-provided name for this operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of operation to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation to update.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of operation to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation to update.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The subtype of the operation, providing additional categorization.
     * </p>
     * 
     * @return The subtype of the operation, providing additional categorization.
     */
    public final String subType() {
        return subType;
    }

    /**
     * <p>
     * The action to take on the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link OperationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on the operation.
     * @see OperationAction
     */
    public final OperationAction action() {
        return OperationAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take on the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link OperationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on the operation.
     * @see OperationAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The payload for successful operations.
     * </p>
     * 
     * @return The payload for successful operations.
     */
    public final String payload() {
        return payload;
    }

    /**
     * <p>
     * The error information for failed operations.
     * </p>
     * 
     * @return The error information for failed operations.
     */
    public final ErrorObject error() {
        return error;
    }

    /**
     * <p>
     * Options for context operations.
     * </p>
     * 
     * @return Options for context operations.
     */
    public final ContextOptions contextOptions() {
        return contextOptions;
    }

    /**
     * <p>
     * Options for step operations.
     * </p>
     * 
     * @return Options for step operations.
     */
    public final StepOptions stepOptions() {
        return stepOptions;
    }

    /**
     * <p>
     * Options for wait operations.
     * </p>
     * 
     * @return Options for wait operations.
     */
    public final WaitOptions waitOptions() {
        return waitOptions;
    }

    /**
     * Returns the value of the CallbackOptions property for this object.
     * 
     * @return The value of the CallbackOptions property for this object.
     */
    public final CallbackOptions callbackOptions() {
        return callbackOptions;
    }

    /**
     * Returns the value of the ChainedInvokeOptions property for this object.
     * 
     * @return The value of the ChainedInvokeOptions property for this object.
     */
    public final ChainedInvokeOptions chainedInvokeOptions() {
        return chainedInvokeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(contextOptions());
        hashCode = 31 * hashCode + Objects.hashCode(stepOptions());
        hashCode = 31 * hashCode + Objects.hashCode(waitOptions());
        hashCode = 31 * hashCode + Objects.hashCode(callbackOptions());
        hashCode = 31 * hashCode + Objects.hashCode(chainedInvokeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationUpdate)) {
            return false;
        }
        OperationUpdate other = (OperationUpdate) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(parentId(), other.parentId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(subType(), other.subType()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(payload(), other.payload()) && Objects.equals(error(), other.error())
                && Objects.equals(contextOptions(), other.contextOptions()) && Objects.equals(stepOptions(), other.stepOptions())
                && Objects.equals(waitOptions(), other.waitOptions())
                && Objects.equals(callbackOptions(), other.callbackOptions())
                && Objects.equals(chainedInvokeOptions(), other.chainedInvokeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationUpdate").add("Id", id()).add("ParentId", parentId()).add("Name", name())
                .add("Type", typeAsString()).add("SubType", subType()).add("Action", actionAsString())
                .add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***").add("Error", error())
                .add("ContextOptions", contextOptions()).add("StepOptions", stepOptions()).add("WaitOptions", waitOptions())
                .add("CallbackOptions", callbackOptions()).add("ChainedInvokeOptions", chainedInvokeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subType()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ContextOptions":
            return Optional.ofNullable(clazz.cast(contextOptions()));
        case "StepOptions":
            return Optional.ofNullable(clazz.cast(stepOptions()));
        case "WaitOptions":
            return Optional.ofNullable(clazz.cast(waitOptions()));
        case "CallbackOptions":
            return Optional.ofNullable(clazz.cast(callbackOptions()));
        case "ChainedInvokeOptions":
            return Optional.ofNullable(clazz.cast(chainedInvokeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ContextOptions", CONTEXT_OPTIONS_FIELD);
        map.put("StepOptions", STEP_OPTIONS_FIELD);
        map.put("WaitOptions", WAIT_OPTIONS_FIELD);
        map.put("CallbackOptions", CALLBACK_OPTIONS_FIELD);
        map.put("ChainedInvokeOptions", CHAINED_INVOKE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationUpdate, T> g) {
        return obj -> g.apply((OperationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationUpdate> {
        /**
         * <p>
         * The unique identifier for this operation.
         * </p>
         * 
         * @param id
         *        The unique identifier for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier of the parent operation, if this operation is running within a child context.
         * </p>
         * 
         * @param parentId
         *        The unique identifier of the parent operation, if this operation is running within a child context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * The customer-provided name for this operation.
         * </p>
         * 
         * @param name
         *        The customer-provided name for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of operation to update.
         * </p>
         * 
         * @param type
         *        The type of operation to update.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation to update.
         * </p>
         * 
         * @param type
         *        The type of operation to update.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The subtype of the operation, providing additional categorization.
         * </p>
         * 
         * @param subType
         *        The subtype of the operation, providing additional categorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(String subType);

        /**
         * <p>
         * The action to take on the operation.
         * </p>
         * 
         * @param action
         *        The action to take on the operation.
         * @see OperationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take on the operation.
         * </p>
         * 
         * @param action
         *        The action to take on the operation.
         * @see OperationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationAction
         */
        Builder action(OperationAction action);

        /**
         * <p>
         * The payload for successful operations.
         * </p>
         * 
         * @param payload
         *        The payload for successful operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(String payload);

        /**
         * <p>
         * The error information for failed operations.
         * </p>
         * 
         * @param error
         *        The error information for failed operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorObject error);

        /**
         * <p>
         * The error information for failed operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorObject.Builder} avoiding the need to
         * create one manually via {@link ErrorObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorObject.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorObject)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorObject)
         */
        default Builder error(Consumer<ErrorObject.Builder> error) {
            return error(ErrorObject.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * Options for context operations.
         * </p>
         * 
         * @param contextOptions
         *        Options for context operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextOptions(ContextOptions contextOptions);

        /**
         * <p>
         * Options for context operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextOptions.Builder} avoiding the need
         * to create one manually via {@link ContextOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #contextOptions(ContextOptions)}.
         * 
         * @param contextOptions
         *        a consumer that will call methods on {@link ContextOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextOptions(ContextOptions)
         */
        default Builder contextOptions(Consumer<ContextOptions.Builder> contextOptions) {
            return contextOptions(ContextOptions.builder().applyMutation(contextOptions).build());
        }

        /**
         * <p>
         * Options for step operations.
         * </p>
         * 
         * @param stepOptions
         *        Options for step operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOptions(StepOptions stepOptions);

        /**
         * <p>
         * Options for step operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepOptions.Builder} avoiding the need to
         * create one manually via {@link StepOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #stepOptions(StepOptions)}.
         * 
         * @param stepOptions
         *        a consumer that will call methods on {@link StepOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOptions(StepOptions)
         */
        default Builder stepOptions(Consumer<StepOptions.Builder> stepOptions) {
            return stepOptions(StepOptions.builder().applyMutation(stepOptions).build());
        }

        /**
         * <p>
         * Options for wait operations.
         * </p>
         * 
         * @param waitOptions
         *        Options for wait operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitOptions(WaitOptions waitOptions);

        /**
         * <p>
         * Options for wait operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitOptions.Builder} avoiding the need to
         * create one manually via {@link WaitOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #waitOptions(WaitOptions)}.
         * 
         * @param waitOptions
         *        a consumer that will call methods on {@link WaitOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitOptions(WaitOptions)
         */
        default Builder waitOptions(Consumer<WaitOptions.Builder> waitOptions) {
            return waitOptions(WaitOptions.builder().applyMutation(waitOptions).build());
        }

        /**
         * Sets the value of the CallbackOptions property for this object.
         *
         * @param callbackOptions
         *        The new value for the CallbackOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackOptions(CallbackOptions callbackOptions);

        /**
         * Sets the value of the CallbackOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallbackOptions.Builder} avoiding the
         * need to create one manually via {@link CallbackOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallbackOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #callbackOptions(CallbackOptions)}.
         * 
         * @param callbackOptions
         *        a consumer that will call methods on {@link CallbackOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callbackOptions(CallbackOptions)
         */
        default Builder callbackOptions(Consumer<CallbackOptions.Builder> callbackOptions) {
            return callbackOptions(CallbackOptions.builder().applyMutation(callbackOptions).build());
        }

        /**
         * Sets the value of the ChainedInvokeOptions property for this object.
         *
         * @param chainedInvokeOptions
         *        The new value for the ChainedInvokeOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainedInvokeOptions(ChainedInvokeOptions chainedInvokeOptions);

        /**
         * Sets the value of the ChainedInvokeOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChainedInvokeOptions.Builder} avoiding
         * the need to create one manually via {@link ChainedInvokeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChainedInvokeOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #chainedInvokeOptions(ChainedInvokeOptions)}.
         * 
         * @param chainedInvokeOptions
         *        a consumer that will call methods on {@link ChainedInvokeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chainedInvokeOptions(ChainedInvokeOptions)
         */
        default Builder chainedInvokeOptions(Consumer<ChainedInvokeOptions.Builder> chainedInvokeOptions) {
            return chainedInvokeOptions(ChainedInvokeOptions.builder().applyMutation(chainedInvokeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String parentId;

        private String name;

        private String type;

        private String subType;

        private String action;

        private String payload;

        private ErrorObject error;

        private ContextOptions contextOptions;

        private StepOptions stepOptions;

        private WaitOptions waitOptions;

        private CallbackOptions callbackOptions;

        private ChainedInvokeOptions chainedInvokeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationUpdate model) {
            id(model.id);
            parentId(model.parentId);
            name(model.name);
            type(model.type);
            subType(model.subType);
            action(model.action);
            payload(model.payload);
            error(model.error);
            contextOptions(model.contextOptions);
            stepOptions(model.stepOptions);
            waitOptions(model.waitOptions);
            callbackOptions(model.callbackOptions);
            chainedInvokeOptions(model.chainedInvokeOptions);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(OperationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getPayload() {
            return payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        public final ContextOptions.Builder getContextOptions() {
            return contextOptions != null ? contextOptions.toBuilder() : null;
        }

        public final void setContextOptions(ContextOptions.BuilderImpl contextOptions) {
            this.contextOptions = contextOptions != null ? contextOptions.build() : null;
        }

        @Override
        public final Builder contextOptions(ContextOptions contextOptions) {
            this.contextOptions = contextOptions;
            return this;
        }

        public final StepOptions.Builder getStepOptions() {
            return stepOptions != null ? stepOptions.toBuilder() : null;
        }

        public final void setStepOptions(StepOptions.BuilderImpl stepOptions) {
            this.stepOptions = stepOptions != null ? stepOptions.build() : null;
        }

        @Override
        public final Builder stepOptions(StepOptions stepOptions) {
            this.stepOptions = stepOptions;
            return this;
        }

        public final WaitOptions.Builder getWaitOptions() {
            return waitOptions != null ? waitOptions.toBuilder() : null;
        }

        public final void setWaitOptions(WaitOptions.BuilderImpl waitOptions) {
            this.waitOptions = waitOptions != null ? waitOptions.build() : null;
        }

        @Override
        public final Builder waitOptions(WaitOptions waitOptions) {
            this.waitOptions = waitOptions;
            return this;
        }

        public final CallbackOptions.Builder getCallbackOptions() {
            return callbackOptions != null ? callbackOptions.toBuilder() : null;
        }

        public final void setCallbackOptions(CallbackOptions.BuilderImpl callbackOptions) {
            this.callbackOptions = callbackOptions != null ? callbackOptions.build() : null;
        }

        @Override
        public final Builder callbackOptions(CallbackOptions callbackOptions) {
            this.callbackOptions = callbackOptions;
            return this;
        }

        public final ChainedInvokeOptions.Builder getChainedInvokeOptions() {
            return chainedInvokeOptions != null ? chainedInvokeOptions.toBuilder() : null;
        }

        public final void setChainedInvokeOptions(ChainedInvokeOptions.BuilderImpl chainedInvokeOptions) {
            this.chainedInvokeOptions = chainedInvokeOptions != null ? chainedInvokeOptions.build() : null;
        }

        @Override
        public final Builder chainedInvokeOptions(ChainedInvokeOptions chainedInvokeOptions) {
            this.chainedInvokeOptions = chainedInvokeOptions;
            return this;
        }

        @Override
        public OperationUpdate build() {
            return new OperationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
