/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(Environment.getter(Environment::variables)).setter(Environment.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Environment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> variables;

    private Environment(BuilderImpl builder) {
        this.variables = builder.variables;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("Variables", VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.variables(model.variables);
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder variables(Map<String, String> var1);
    }
}

