/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionRecursionConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<GetFunctionRecursionConfigResponse.Builder, GetFunctionRecursionConfigResponse> {
    private static final SdkField<String> RECURSIVE_LOOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecursiveLoop").getter(getter(GetFunctionRecursionConfigResponse::recursiveLoopAsString))
            .setter(setter(Builder::recursiveLoop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecursiveLoop").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECURSIVE_LOOP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recursiveLoop;

    private GetFunctionRecursionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.recursiveLoop = builder.recursiveLoop;
    }

    /**
     * <p>
     * If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any action
     * when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your function
     * being invoked and notifies you when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
     * configuration using the <a>PutFunctionRecursionConfig</a> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any
     *         action when it detects your function being invoked as part of a recursive loop.</p>
     *         <p>
     *         If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
     *         function being invoked and notifies you when it detects your function being invoked as part of a
     *         recursive loop.
     *         </p>
     *         <p>
     *         By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
     *         configuration using the <a>PutFunctionRecursionConfig</a> action.
     * @see RecursiveLoop
     */
    public final RecursiveLoop recursiveLoop() {
        return RecursiveLoop.fromValue(recursiveLoop);
    }

    /**
     * <p>
     * If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any action
     * when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your function
     * being invoked and notifies you when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
     * configuration using the <a>PutFunctionRecursionConfig</a> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any
     *         action when it detects your function being invoked as part of a recursive loop.</p>
     *         <p>
     *         If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
     *         function being invoked and notifies you when it detects your function being invoked as part of a
     *         recursive loop.
     *         </p>
     *         <p>
     *         By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
     *         configuration using the <a>PutFunctionRecursionConfig</a> action.
     * @see RecursiveLoop
     */
    public final String recursiveLoopAsString() {
        return recursiveLoop;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recursiveLoopAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionRecursionConfigResponse)) {
            return false;
        }
        GetFunctionRecursionConfigResponse other = (GetFunctionRecursionConfigResponse) obj;
        return Objects.equals(recursiveLoopAsString(), other.recursiveLoopAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionRecursionConfigResponse").add("RecursiveLoop", recursiveLoopAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecursiveLoop":
            return Optional.ofNullable(clazz.cast(recursiveLoopAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecursiveLoop", RECURSIVE_LOOP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionRecursionConfigResponse, T> g) {
        return obj -> g.apply((GetFunctionRecursionConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFunctionRecursionConfigResponse> {
        /**
         * <p>
         * If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any
         * action when it detects your function being invoked as part of a recursive loop.
         * </p>
         * <p>
         * If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
         * function being invoked and notifies you when it detects your function being invoked as part of a recursive
         * loop.
         * </p>
         * <p>
         * By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
         * configuration using the <a>PutFunctionRecursionConfig</a> action.
         * </p>
         * 
         * @param recursiveLoop
         *        If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take
         *        any action when it detects your function being invoked as part of a recursive loop.</p>
         *        <p>
         *        If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
         *        function being invoked and notifies you when it detects your function being invoked as part of a
         *        recursive loop.
         *        </p>
         *        <p>
         *        By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
         *        configuration using the <a>PutFunctionRecursionConfig</a> action.
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(String recursiveLoop);

        /**
         * <p>
         * If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take any
         * action when it detects your function being invoked as part of a recursive loop.
         * </p>
         * <p>
         * If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
         * function being invoked and notifies you when it detects your function being invoked as part of a recursive
         * loop.
         * </p>
         * <p>
         * By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
         * configuration using the <a>PutFunctionRecursionConfig</a> action.
         * </p>
         * 
         * @param recursiveLoop
         *        If your function's recursive loop detection configuration is <code>Allow</code>, Lambda doesn't take
         *        any action when it detects your function being invoked as part of a recursive loop.</p>
         *        <p>
         *        If your function's recursive loop detection configuration is <code>Terminate</code>, Lambda stops your
         *        function being invoked and notifies you when it detects your function being invoked as part of a
         *        recursive loop.
         *        </p>
         *        <p>
         *        By default, Lambda sets your function's configuration to <code>Terminate</code>. You can update this
         *        configuration using the <a>PutFunctionRecursionConfig</a> action.
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(RecursiveLoop recursiveLoop);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String recursiveLoop;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionRecursionConfigResponse model) {
            super(model);
            recursiveLoop(model.recursiveLoop);
        }

        public final String getRecursiveLoop() {
            return recursiveLoop;
        }

        public final void setRecursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
        }

        @Override
        public final Builder recursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
            return this;
        }

        @Override
        public final Builder recursiveLoop(RecursiveLoop recursiveLoop) {
            this.recursiveLoop(recursiveLoop == null ? null : recursiveLoop.toString());
            return this;
        }

        @Override
        public GetFunctionRecursionConfigResponse build() {
            return new GetFunctionRecursionConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
