/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.Architecture;
import software.amazon.awssdk.services.lambda.model.CompatibleArchitecturesCopier;
import software.amazon.awssdk.services.lambda.model.CompatibleRuntimesCopier;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayerVersionsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayerVersionsListItem> {
    private static final SdkField<String> LAYER_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerVersionArn").getter(LayerVersionsListItem.getter(LayerVersionsListItem::layerVersionArn)).setter(LayerVersionsListItem.setter(Builder::layerVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersionArn").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(LayerVersionsListItem.getter(LayerVersionsListItem::version)).setter(LayerVersionsListItem.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LayerVersionsListItem.getter(LayerVersionsListItem::description)).setter(LayerVersionsListItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(LayerVersionsListItem.getter(LayerVersionsListItem::createdDate)).setter(LayerVersionsListItem.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompatibleRuntimes").getter(LayerVersionsListItem.getter(LayerVersionsListItem::compatibleRuntimesAsStrings)).setter(LayerVersionsListItem.setter(Builder::compatibleRuntimesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseInfo").getter(LayerVersionsListItem.getter(LayerVersionsListItem::licenseInfo)).setter(LayerVersionsListItem.setter(Builder::licenseInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompatibleArchitectures").getter(LayerVersionsListItem.getter(LayerVersionsListItem::compatibleArchitecturesAsStrings)).setter(LayerVersionsListItem.setter(Builder::compatibleArchitecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleArchitectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_VERSION_ARN_FIELD, VERSION_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD, COMPATIBLE_ARCHITECTURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LayerVersionsListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String layerVersionArn;
    private final Long version;
    private final String description;
    private final String createdDate;
    private final List<String> compatibleRuntimes;
    private final String licenseInfo;
    private final List<String> compatibleArchitectures;

    private LayerVersionsListItem(BuilderImpl builder) {
        this.layerVersionArn = builder.layerVersionArn;
        this.version = builder.version;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
        this.compatibleArchitectures = builder.compatibleArchitectures;
    }

    public final String layerVersionArn() {
        return this.layerVersionArn;
    }

    public final Long version() {
        return this.version;
    }

    public final String description() {
        return this.description;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(this.compatibleRuntimes);
    }

    public final boolean hasCompatibleRuntimes() {
        return this.compatibleRuntimes != null && !(this.compatibleRuntimes instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleRuntimesAsStrings() {
        return this.compatibleRuntimes;
    }

    public final String licenseInfo() {
        return this.licenseInfo;
    }

    public final List<Architecture> compatibleArchitectures() {
        return CompatibleArchitecturesCopier.copyStringToEnum(this.compatibleArchitectures);
    }

    public final boolean hasCompatibleArchitectures() {
        return this.compatibleArchitectures != null && !(this.compatibleArchitectures instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleArchitecturesAsStrings() {
        return this.compatibleArchitectures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleRuntimes() ? this.compatibleRuntimesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleArchitectures() ? this.compatibleArchitecturesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionsListItem)) {
            return false;
        }
        LayerVersionsListItem other = (LayerVersionsListItem)obj;
        return Objects.equals(this.layerVersionArn(), other.layerVersionArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && this.hasCompatibleRuntimes() == other.hasCompatibleRuntimes() && Objects.equals(this.compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings()) && Objects.equals(this.licenseInfo(), other.licenseInfo()) && this.hasCompatibleArchitectures() == other.hasCompatibleArchitectures() && Objects.equals(this.compatibleArchitecturesAsStrings(), other.compatibleArchitecturesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LayerVersionsListItem").add("LayerVersionArn", (Object)this.layerVersionArn()).add("Version", (Object)this.version()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("CompatibleRuntimes", this.hasCompatibleRuntimes() ? this.compatibleRuntimesAsStrings() : null).add("LicenseInfo", (Object)this.licenseInfo()).add("CompatibleArchitectures", this.hasCompatibleArchitectures() ? this.compatibleArchitecturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerVersionArn": {
                return Optional.ofNullable(clazz.cast(this.layerVersionArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "CompatibleRuntimes": {
                return Optional.ofNullable(clazz.cast(this.compatibleRuntimesAsStrings()));
            }
            case "LicenseInfo": {
                return Optional.ofNullable(clazz.cast(this.licenseInfo()));
            }
            case "CompatibleArchitectures": {
                return Optional.ofNullable(clazz.cast(this.compatibleArchitecturesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LayerVersionArn", LAYER_VERSION_ARN_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("CompatibleRuntimes", COMPATIBLE_RUNTIMES_FIELD);
        map.put("LicenseInfo", LICENSE_INFO_FIELD);
        map.put("CompatibleArchitectures", COMPATIBLE_ARCHITECTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayerVersionsListItem, T> g) {
        return obj -> g.apply((LayerVersionsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerVersionArn;
        private Long version;
        private String description;
        private String createdDate;
        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();
        private String licenseInfo;
        private List<String> compatibleArchitectures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LayerVersionsListItem model) {
            this.layerVersionArn(model.layerVersionArn);
            this.version(model.version);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.compatibleRuntimesWithStrings(model.compatibleRuntimes);
            this.licenseInfo(model.licenseInfo);
            this.compatibleArchitecturesWithStrings(model.compatibleArchitectures);
        }

        public final String getLayerVersionArn() {
            return this.layerVersionArn;
        }

        public final void setLayerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
        }

        @Override
        public final Builder layerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (this.compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        @Override
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String ... compatibleRuntimes) {
            this.compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime ... compatibleRuntimes) {
            this.compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getLicenseInfo() {
            return this.licenseInfo;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        public final Collection<String> getCompatibleArchitectures() {
            if (this.compatibleArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleArchitectures;
        }

        public final void setCompatibleArchitectures(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
        }

        @Override
        public final Builder compatibleArchitecturesWithStrings(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitecturesWithStrings(String ... compatibleArchitectures) {
            this.compatibleArchitecturesWithStrings(Arrays.asList(compatibleArchitectures));
            return this;
        }

        @Override
        public final Builder compatibleArchitectures(Collection<Architecture> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copyEnumToString(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitectures(Architecture ... compatibleArchitectures) {
            this.compatibleArchitectures(Arrays.asList(compatibleArchitectures));
            return this;
        }

        public LayerVersionsListItem build() {
            return new LayerVersionsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayerVersionsListItem> {
        public Builder layerVersionArn(String var1);

        public Builder version(Long var1);

        public Builder description(String var1);

        public Builder createdDate(String var1);

        public Builder compatibleRuntimesWithStrings(Collection<String> var1);

        public Builder compatibleRuntimesWithStrings(String ... var1);

        public Builder compatibleRuntimes(Collection<Runtime> var1);

        public Builder compatibleRuntimes(Runtime ... var1);

        public Builder licenseInfo(String var1);

        public Builder compatibleArchitecturesWithStrings(Collection<String> var1);

        public Builder compatibleArchitecturesWithStrings(String ... var1);

        public Builder compatibleArchitectures(Collection<Architecture> var1);

        public Builder compatibleArchitectures(Architecture ... var1);
    }
}

