/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionCodeLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionCodeLocation> {
    private static final SdkField<String> REPOSITORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryType").getter(FunctionCodeLocation.getter(FunctionCodeLocation::repositoryType)).setter(FunctionCodeLocation.setter(Builder::repositoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryType").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(FunctionCodeLocation.getter(FunctionCodeLocation::location)).setter(FunctionCodeLocation.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(FunctionCodeLocation.getter(FunctionCodeLocation::imageUri)).setter(FunctionCodeLocation.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<String> RESOLVED_IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolvedImageUri").getter(FunctionCodeLocation.getter(FunctionCodeLocation::resolvedImageUri)).setter(FunctionCodeLocation.setter(Builder::resolvedImageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedImageUri").build()}).build();
    private static final SdkField<String> SOURCE_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKMSKeyArn").getter(FunctionCodeLocation.getter(FunctionCodeLocation::sourceKMSKeyArn)).setter(FunctionCodeLocation.setter(Builder::sourceKMSKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceKMSKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_TYPE_FIELD, LOCATION_FIELD, IMAGE_URI_FIELD, RESOLVED_IMAGE_URI_FIELD, SOURCE_KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionCodeLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repositoryType;
    private final String location;
    private final String imageUri;
    private final String resolvedImageUri;
    private final String sourceKMSKeyArn;

    private FunctionCodeLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
        this.imageUri = builder.imageUri;
        this.resolvedImageUri = builder.resolvedImageUri;
        this.sourceKMSKeyArn = builder.sourceKMSKeyArn;
    }

    public final String repositoryType() {
        return this.repositoryType;
    }

    public final String location() {
        return this.location;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final String resolvedImageUri() {
        return this.resolvedImageUri;
    }

    public final String sourceKMSKeyArn() {
        return this.sourceKMSKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedImageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKMSKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCodeLocation)) {
            return false;
        }
        FunctionCodeLocation other = (FunctionCodeLocation)obj;
        return Objects.equals(this.repositoryType(), other.repositoryType()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.resolvedImageUri(), other.resolvedImageUri()) && Objects.equals(this.sourceKMSKeyArn(), other.sourceKMSKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionCodeLocation").add("RepositoryType", (Object)this.repositoryType()).add("Location", (Object)this.location()).add("ImageUri", (Object)this.imageUri()).add("ResolvedImageUri", (Object)this.resolvedImageUri()).add("SourceKMSKeyArn", (Object)this.sourceKMSKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryType": {
                return Optional.ofNullable(clazz.cast(this.repositoryType()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ResolvedImageUri": {
                return Optional.ofNullable(clazz.cast(this.resolvedImageUri()));
            }
            case "SourceKMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.sourceKMSKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RepositoryType", REPOSITORY_TYPE_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ImageUri", IMAGE_URI_FIELD);
        map.put("ResolvedImageUri", RESOLVED_IMAGE_URI_FIELD);
        map.put("SourceKMSKeyArn", SOURCE_KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionCodeLocation, T> g) {
        return obj -> g.apply((FunctionCodeLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryType;
        private String location;
        private String imageUri;
        private String resolvedImageUri;
        private String sourceKMSKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCodeLocation model) {
            this.repositoryType(model.repositoryType);
            this.location(model.location);
            this.imageUri(model.imageUri);
            this.resolvedImageUri(model.resolvedImageUri);
            this.sourceKMSKeyArn(model.sourceKMSKeyArn);
        }

        public final String getRepositoryType() {
            return this.repositoryType;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final String getResolvedImageUri() {
            return this.resolvedImageUri;
        }

        public final void setResolvedImageUri(String resolvedImageUri) {
            this.resolvedImageUri = resolvedImageUri;
        }

        @Override
        public final Builder resolvedImageUri(String resolvedImageUri) {
            this.resolvedImageUri = resolvedImageUri;
            return this;
        }

        public final String getSourceKMSKeyArn() {
            return this.sourceKMSKeyArn;
        }

        public final void setSourceKMSKeyArn(String sourceKMSKeyArn) {
            this.sourceKMSKeyArn = sourceKMSKeyArn;
        }

        @Override
        public final Builder sourceKMSKeyArn(String sourceKMSKeyArn) {
            this.sourceKMSKeyArn = sourceKMSKeyArn;
            return this;
        }

        public FunctionCodeLocation build() {
            return new FunctionCodeLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionCodeLocation> {
        public Builder repositoryType(String var1);

        public Builder location(String var1);

        public Builder imageUri(String var1);

        public Builder resolvedImageUri(String var1);

        public Builder sourceKMSKeyArn(String var1);
    }
}

