/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.AllowedPublishers;
import software.amazon.awssdk.services.lambda.model.CodeSigningPolicies;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCodeSigningConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateCodeSigningConfigRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCodeSigningConfigRequest.getter(CreateCodeSigningConfigRequest::description)).setter(CreateCodeSigningConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AllowedPublishers> ALLOWED_PUBLISHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllowedPublishers").getter(CreateCodeSigningConfigRequest.getter(CreateCodeSigningConfigRequest::allowedPublishers)).setter(CreateCodeSigningConfigRequest.setter(Builder::allowedPublishers)).constructor(AllowedPublishers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPublishers").build()}).build();
    private static final SdkField<CodeSigningPolicies> CODE_SIGNING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeSigningPolicies").getter(CreateCodeSigningConfigRequest.getter(CreateCodeSigningConfigRequest::codeSigningPolicies)).setter(CreateCodeSigningConfigRequest.setter(Builder::codeSigningPolicies)).constructor(CodeSigningPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningPolicies").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCodeSigningConfigRequest.getter(CreateCodeSigningConfigRequest::tags)).setter(CreateCodeSigningConfigRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ALLOWED_PUBLISHERS_FIELD, CODE_SIGNING_POLICIES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCodeSigningConfigRequest.memberNameToFieldInitializer();
    private final String description;
    private final AllowedPublishers allowedPublishers;
    private final CodeSigningPolicies codeSigningPolicies;
    private final Map<String, String> tags;

    private CreateCodeSigningConfigRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.allowedPublishers = builder.allowedPublishers;
        this.codeSigningPolicies = builder.codeSigningPolicies;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final AllowedPublishers allowedPublishers() {
        return this.allowedPublishers;
    }

    public final CodeSigningPolicies codeSigningPolicies() {
        return this.codeSigningPolicies;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPublishers());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeSigningConfigRequest)) {
            return false;
        }
        CreateCodeSigningConfigRequest other = (CreateCodeSigningConfigRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.allowedPublishers(), other.allowedPublishers()) && Objects.equals(this.codeSigningPolicies(), other.codeSigningPolicies()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCodeSigningConfigRequest").add("Description", (Object)this.description()).add("AllowedPublishers", (Object)this.allowedPublishers()).add("CodeSigningPolicies", (Object)this.codeSigningPolicies()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedPublishers": {
                return Optional.ofNullable(clazz.cast(this.allowedPublishers()));
            }
            case "CodeSigningPolicies": {
                return Optional.ofNullable(clazz.cast(this.codeSigningPolicies()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AllowedPublishers", ALLOWED_PUBLISHERS_FIELD);
        map.put("CodeSigningPolicies", CODE_SIGNING_POLICIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeSigningConfigRequest, T> g) {
        return obj -> g.apply((CreateCodeSigningConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String description;
        private AllowedPublishers allowedPublishers;
        private CodeSigningPolicies codeSigningPolicies;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeSigningConfigRequest model) {
            super(model);
            this.description(model.description);
            this.allowedPublishers(model.allowedPublishers);
            this.codeSigningPolicies(model.codeSigningPolicies);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AllowedPublishers.Builder getAllowedPublishers() {
            return this.allowedPublishers != null ? this.allowedPublishers.toBuilder() : null;
        }

        public final void setAllowedPublishers(AllowedPublishers.BuilderImpl allowedPublishers) {
            this.allowedPublishers = allowedPublishers != null ? allowedPublishers.build() : null;
        }

        @Override
        public final Builder allowedPublishers(AllowedPublishers allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        public final CodeSigningPolicies.Builder getCodeSigningPolicies() {
            return this.codeSigningPolicies != null ? this.codeSigningPolicies.toBuilder() : null;
        }

        public final void setCodeSigningPolicies(CodeSigningPolicies.BuilderImpl codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies != null ? codeSigningPolicies.build() : null;
        }

        @Override
        public final Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeSigningConfigRequest build() {
            return new CreateCodeSigningConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCodeSigningConfigRequest> {
        public Builder description(String var1);

        public Builder allowedPublishers(AllowedPublishers var1);

        default public Builder allowedPublishers(Consumer<AllowedPublishers.Builder> allowedPublishers) {
            return this.allowedPublishers((AllowedPublishers)((AllowedPublishers.Builder)AllowedPublishers.builder().applyMutation(allowedPublishers)).build());
        }

        public Builder codeSigningPolicies(CodeSigningPolicies var1);

        default public Builder codeSigningPolicies(Consumer<CodeSigningPolicies.Builder> codeSigningPolicies) {
            return this.codeSigningPolicies((CodeSigningPolicies)((CodeSigningPolicies.Builder)CodeSigningPolicies.builder().applyMutation(codeSigningPolicies)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

