/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.FullDocument;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentDBEventSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentDBEventSourceConfig> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DocumentDBEventSourceConfig.getter(DocumentDBEventSourceConfig::databaseName)).setter(DocumentDBEventSourceConfig.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(DocumentDBEventSourceConfig.getter(DocumentDBEventSourceConfig::collectionName)).setter(DocumentDBEventSourceConfig.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<String> FULL_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FullDocument").getter(DocumentDBEventSourceConfig.getter(DocumentDBEventSourceConfig::fullDocumentAsString)).setter(DocumentDBEventSourceConfig.setter(Builder::fullDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, COLLECTION_NAME_FIELD, FULL_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("CollectionName", COLLECTION_NAME_FIELD);
            this.put("FullDocument", FULL_DOCUMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String collectionName;
    private final String fullDocument;

    private DocumentDBEventSourceConfig(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.fullDocument = builder.fullDocument;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final FullDocument fullDocument() {
        return FullDocument.fromValue(this.fullDocument);
    }

    public final String fullDocumentAsString() {
        return this.fullDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullDocumentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDBEventSourceConfig)) {
            return false;
        }
        DocumentDBEventSourceConfig other = (DocumentDBEventSourceConfig)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.fullDocumentAsString(), other.fullDocumentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentDBEventSourceConfig").add("DatabaseName", (Object)this.databaseName()).add("CollectionName", (Object)this.collectionName()).add("FullDocument", (Object)this.fullDocumentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "FullDocument": {
                return Optional.ofNullable(clazz.cast(this.fullDocumentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DocumentDBEventSourceConfig, T> g) {
        return obj -> g.apply((DocumentDBEventSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String collectionName;
        private String fullDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDBEventSourceConfig model) {
            this.databaseName(model.databaseName);
            this.collectionName(model.collectionName);
            this.fullDocument(model.fullDocument);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getFullDocument() {
            return this.fullDocument;
        }

        public final void setFullDocument(String fullDocument) {
            this.fullDocument = fullDocument;
        }

        @Override
        public final Builder fullDocument(String fullDocument) {
            this.fullDocument = fullDocument;
            return this;
        }

        @Override
        public final Builder fullDocument(FullDocument fullDocument) {
            this.fullDocument(fullDocument == null ? null : fullDocument.toString());
            return this;
        }

        public DocumentDBEventSourceConfig build() {
            return new DocumentDBEventSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentDBEventSourceConfig> {
        public Builder databaseName(String var1);

        public Builder collectionName(String var1);

        public Builder fullDocument(String var1);

        public Builder fullDocument(FullDocument var1);
    }
}

