/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum StateReasonCode {
    IDLE("Idle"),

    CREATING("Creating"),

    RESTORING("Restoring"),

    ENI_LIMIT_EXCEEDED("EniLimitExceeded"),

    INSUFFICIENT_ROLE_PERMISSIONS("InsufficientRolePermissions"),

    INVALID_CONFIGURATION("InvalidConfiguration"),

    INTERNAL_ERROR("InternalError"),

    SUBNET_OUT_OF_IP_ADDRESSES("SubnetOutOfIPAddresses"),

    INVALID_SUBNET("InvalidSubnet"),

    INVALID_SECURITY_GROUP("InvalidSecurityGroup"),

    IMAGE_DELETED("ImageDeleted"),

    IMAGE_ACCESS_DENIED("ImageAccessDenied"),

    INVALID_IMAGE("InvalidImage"),

    KMS_KEY_ACCESS_DENIED("KMSKeyAccessDenied"),

    KMS_KEY_NOT_FOUND("KMSKeyNotFound"),

    INVALID_STATE_KMS_KEY("InvalidStateKMSKey"),

    DISABLED_KMS_KEY("DisabledKMSKey"),

    EFSIO_ERROR("EFSIOError"),

    EFS_MOUNT_CONNECTIVITY_ERROR("EFSMountConnectivityError"),

    EFS_MOUNT_FAILURE("EFSMountFailure"),

    EFS_MOUNT_TIMEOUT("EFSMountTimeout"),

    INVALID_RUNTIME("InvalidRuntime"),

    INVALID_ZIP_FILE_EXCEPTION("InvalidZipFileException"),

    FUNCTION_ERROR("FunctionError"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateReasonCode> VALUE_MAP = EnumUtils.uniqueIndex(StateReasonCode.class,
            StateReasonCode::toString);

    private final String value;

    private StateReasonCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StateReasonCode corresponding to the value
     */
    public static StateReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StateReasonCode}s
     */
    public static Set<StateReasonCode> knownValues() {
        Set<StateReasonCode> knownValues = EnumSet.allOf(StateReasonCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
