/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionsByCodeSigningConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<ListFunctionsByCodeSigningConfigResponse.Builder, ListFunctionsByCodeSigningConfigResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFunctionsByCodeSigningConfigResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<String>> FUNCTION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FunctionArns")
            .getter(getter(ListFunctionsByCodeSigningConfigResponse::functionArns))
            .setter(setter(Builder::functionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            FUNCTION_ARNS_FIELD));

    private final String nextMarker;

    private final List<String> functionArns;

    private ListFunctionsByCodeSigningConfigResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.functionArns = builder.functionArns;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionArns() {
        return functionArns != null && !(functionArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The function ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionArns} method.
     * </p>
     * 
     * @return The function ARNs.
     */
    public final List<String> functionArns() {
        return functionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionArns() ? functionArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsByCodeSigningConfigResponse)) {
            return false;
        }
        ListFunctionsByCodeSigningConfigResponse other = (ListFunctionsByCodeSigningConfigResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasFunctionArns() == other.hasFunctionArns()
                && Objects.equals(functionArns(), other.functionArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFunctionsByCodeSigningConfigResponse").add("NextMarker", nextMarker())
                .add("FunctionArns", hasFunctionArns() ? functionArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "FunctionArns":
            return Optional.ofNullable(clazz.cast(functionArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsByCodeSigningConfigResponse, T> g) {
        return obj -> g.apply((ListFunctionsByCodeSigningConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFunctionsByCodeSigningConfigResponse> {
        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The function ARNs.
         * </p>
         * 
         * @param functionArns
         *        The function ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArns(Collection<String> functionArns);

        /**
         * <p>
         * The function ARNs.
         * </p>
         * 
         * @param functionArns
         *        The function ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArns(String... functionArns);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<String> functionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsByCodeSigningConfigResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            functionArns(model.functionArns);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Collection<String> getFunctionArns() {
            if (functionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return functionArns;
        }

        public final void setFunctionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnListCopier.copy(functionArns);
        }

        @Override
        public final Builder functionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnListCopier.copy(functionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionArns(String... functionArns) {
            functionArns(Arrays.asList(functionArns));
            return this;
        }

        @Override
        public ListFunctionsByCodeSigningConfigResponse build() {
            return new ListFunctionsByCodeSigningConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
