/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse;

public class ListFunctionsByCodeSigningConfigPublisher
implements SdkPublisher<ListFunctionsByCodeSigningConfigResponse> {
    private final LambdaAsyncClient client;
    private final ListFunctionsByCodeSigningConfigRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionsByCodeSigningConfigPublisher(LambdaAsyncClient client, ListFunctionsByCodeSigningConfigRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionsByCodeSigningConfigPublisher(LambdaAsyncClient client, ListFunctionsByCodeSigningConfigRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionsByCodeSigningConfigResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionsByCodeSigningConfigResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> functionArns() {
        Function<ListFunctionsByCodeSigningConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionArns() != null) {
                return response.functionArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFunctionsByCodeSigningConfigResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFunctionsByCodeSigningConfigResponseFetcher
    implements AsyncPageFetcher<ListFunctionsByCodeSigningConfigResponse> {
        private ListFunctionsByCodeSigningConfigResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsByCodeSigningConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFunctionsByCodeSigningConfigResponse> nextPage(ListFunctionsByCodeSigningConfigResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsByCodeSigningConfigPublisher.this.client.listFunctionsByCodeSigningConfig(ListFunctionsByCodeSigningConfigPublisher.this.firstRequest);
            }
            return ListFunctionsByCodeSigningConfigPublisher.this.client.listFunctionsByCodeSigningConfig((ListFunctionsByCodeSigningConfigRequest)((Object)ListFunctionsByCodeSigningConfigPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

