/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * To secure and define access to your event source, you can specify the authentication protocol, VPC components, or
 * virtual host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceAccessConfiguration.Builder, SourceAccessConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SourceAccessConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URI")
            .getter(getter(SourceAccessConfiguration::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String uri;

    private SourceAccessConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * The type of authentication protocol, VPC components, or virtual host for your event source. For example:
     * <code>"Type":"SASL_SCRAM_512_AUTH"</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
     * SASL/PLAIN authentication of your Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects to
     * these subnets to fetch data from your self-managed Apache Kafka cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage access to
     * your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used
     * for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your secret
     * key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this
     * RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of
     * your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password
     * (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
     * containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of authentication protocol, VPC components, or virtual host for your event source. For example:
     *         <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
     *         SASL/PLAIN authentication of your Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda
     *         connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage
     *         access to your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
     *         used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of
     *         your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses
     *         this RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping
     *         API call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager
     *         ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and
     *         private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your
     *         secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka
     *         brokers.
     *         </p>
     *         </li>
     * @see SourceAccessType
     */
    public final SourceAccessType type() {
        return SourceAccessType.fromValue(type);
    }

    /**
     * <p>
     * The type of authentication protocol, VPC components, or virtual host for your event source. For example:
     * <code>"Type":"SASL_SCRAM_512_AUTH"</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
     * SASL/PLAIN authentication of your Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects to
     * these subnets to fetch data from your self-managed Apache Kafka cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage access to
     * your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used
     * for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your secret
     * key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this
     * RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of
     * your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password
     * (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
     * containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of authentication protocol, VPC components, or virtual host for your event source. For example:
     *         <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
     *         SASL/PLAIN authentication of your Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda
     *         connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage
     *         access to your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
     *         used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of
     *         your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses
     *         this RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping
     *         API call.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager
     *         ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and
     *         private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your
     *         secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka
     *         brokers.
     *         </p>
     *         </li>
     * @see SourceAccessType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The value for your chosen configuration in <code>Type</code>. For example:
     * <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.
     * </p>
     * 
     * @return The value for your chosen configuration in <code>Type</code>. For example:
     *         <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAccessConfiguration)) {
            return false;
        }
        SourceAccessConfiguration other = (SourceAccessConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceAccessConfiguration").add("Type", typeAsString()).add("URI", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "URI":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAccessConfiguration, T> g) {
        return obj -> g.apply((SourceAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAccessConfiguration> {
        /**
         * <p>
         * The type of authentication protocol, VPC components, or virtual host for your event source. For example:
         * <code>"Type":"SASL_SCRAM_512_AUTH"</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
         * SASL/PLAIN authentication of your Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects
         * to these subnets to fetch data from your self-managed Apache Kafka cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage access to
         * your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
         * used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your
         * secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this
         * RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of
         * your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key
         * password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret
         * key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of authentication protocol, VPC components, or virtual host for your event source. For
         *        example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used
         *        for SASL/PLAIN authentication of your Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda
         *        connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage
         *        access to your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret
         *        key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of
         *        your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda
         *        uses this RabbitMQ host as the event source. This property cannot be specified in an
         *        UpdateEventSourceMapping API call.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager
         *        ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and
         *        private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your
         *        secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka
         *        brokers.
         *        </p>
         *        </li>
         * @see SourceAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAccessType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of authentication protocol, VPC components, or virtual host for your event source. For example:
         * <code>"Type":"SASL_SCRAM_512_AUTH"</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for
         * SASL/PLAIN authentication of your Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects
         * to these subnets to fetch data from your self-managed Apache Kafka cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage access to
         * your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key
         * used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your
         * secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this
         * RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of
         * your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key
         * password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret
         * key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of authentication protocol, VPC components, or virtual host for your event source. For
         *        example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used
         *        for SASL/PLAIN authentication of your Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPC_SUBNET</code> - (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda
         *        connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPC_SECURITY_GROUP</code> - (Self-managed Apache Kafka) The VPC security group used to manage
         *        access to your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SASL_SCRAM_256_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret
         *        key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SASL_SCRAM_512_AUTH</code> - (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of
         *        your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIRTUAL_HOST</code> - (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda
         *        uses this RabbitMQ host as the event source. This property cannot be specified in an
         *        UpdateEventSourceMapping API call.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLIENT_CERTIFICATE_TLS_AUTH</code> - (Amazon MSK, self-managed Apache Kafka) The Secrets Manager
         *        ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and
         *        private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVER_ROOT_CA_CERTIFICATE</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your
         *        secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka
         *        brokers.
         *        </p>
         *        </li>
         * @see SourceAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAccessType
         */
        Builder type(SourceAccessType type);

        /**
         * <p>
         * The value for your chosen configuration in <code>Type</code>. For example:
         * <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.
         * </p>
         * 
         * @param uri
         *        The value for your chosen configuration in <code>Type</code>. For example:
         *        <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAccessConfiguration model) {
            type(model.type);
            uri(model.uri);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceAccessType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public SourceAccessConfiguration build() {
            return new SourceAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
