/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.LayersListItem;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;

public class ListLayersIterable
implements SdkIterable<ListLayersResponse> {
    private final LambdaClient client;
    private final ListLayersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLayersIterable(LambdaClient client, ListLayersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLayersResponseFetcher();
    }

    public Iterator<ListLayersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LayersListItem> layers() {
        Function<ListLayersResponse, Iterator> getIterator = response -> {
            if (response != null && response.layers() != null) {
                return response.layers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLayersResponseFetcher
    implements SyncPageFetcher<ListLayersResponse> {
        private ListLayersResponseFetcher() {
        }

        public boolean hasNextPage(ListLayersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListLayersResponse nextPage(ListLayersResponse previousPage) {
            if (previousPage == null) {
                return ListLayersIterable.this.client.listLayers(ListLayersIterable.this.firstRequest);
            }
            return ListLayersIterable.this.client.listLayers((ListLayersRequest)((Object)ListLayersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

