/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.LayerVersionsListCopier;
import software.amazon.awssdk.services.lambda.model.LayerVersionsListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLayerVersionsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListLayerVersionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListLayerVersionsResponse.getter(ListLayerVersionsResponse::nextMarker)).setter(ListLayerVersionsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<LayerVersionsListItem>> LAYER_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LayerVersions").getter(ListLayerVersionsResponse.getter(ListLayerVersionsResponse::layerVersions)).setter(ListLayerVersionsResponse.setter(Builder::layerVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayerVersionsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, LAYER_VERSIONS_FIELD));
    private final String nextMarker;
    private final List<LayerVersionsListItem> layerVersions;

    private ListLayerVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.layerVersions = builder.layerVersions;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasLayerVersions() {
        return this.layerVersions != null && !(this.layerVersions instanceof SdkAutoConstructList);
    }

    public final List<LayerVersionsListItem> layerVersions() {
        return this.layerVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayerVersions() ? this.layerVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayerVersionsResponse)) {
            return false;
        }
        ListLayerVersionsResponse other = (ListLayerVersionsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasLayerVersions() == other.hasLayerVersions() && Objects.equals(this.layerVersions(), other.layerVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListLayerVersionsResponse").add("NextMarker", (Object)this.nextMarker()).add("LayerVersions", this.hasLayerVersions() ? this.layerVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "LayerVersions": {
                return Optional.ofNullable(clazz.cast(this.layerVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayerVersionsResponse, T> g) {
        return obj -> g.apply((ListLayerVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<LayerVersionsListItem> layerVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayerVersionsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.layerVersions(model.layerVersions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<LayerVersionsListItem.Builder> getLayerVersions() {
            List<LayerVersionsListItem.Builder> result = LayerVersionsListCopier.copyToBuilder(this.layerVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayerVersions(Collection<LayerVersionsListItem.BuilderImpl> layerVersions) {
            this.layerVersions = LayerVersionsListCopier.copyFromBuilder(layerVersions);
        }

        @Override
        @Transient
        public final Builder layerVersions(Collection<LayerVersionsListItem> layerVersions) {
            this.layerVersions = LayerVersionsListCopier.copy(layerVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder layerVersions(LayerVersionsListItem ... layerVersions) {
            this.layerVersions(Arrays.asList(layerVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder layerVersions(Consumer<LayerVersionsListItem.Builder> ... layerVersions) {
            this.layerVersions(Stream.of(layerVersions).map(c -> (LayerVersionsListItem)((LayerVersionsListItem.Builder)LayerVersionsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLayerVersionsResponse build() {
            return new ListLayerVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLayerVersionsResponse> {
        public Builder nextMarker(String var1);

        public Builder layerVersions(Collection<LayerVersionsListItem> var1);

        public Builder layerVersions(LayerVersionsListItem ... var1);

        public Builder layerVersions(Consumer<LayerVersionsListItem.Builder> ... var1);
    }
}

