/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.FileSystemConfig;
import software.amazon.awssdk.services.lambda.model.FileSystemConfigListCopier;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.services.lambda.model.ImageConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LayerListCopier;
import software.amazon.awssdk.services.lambda.model.PackageType;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFunctionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(CreateFunctionRequest.getter(CreateFunctionRequest::functionName)).setter(CreateFunctionRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(CreateFunctionRequest.getter(CreateFunctionRequest::runtimeAsString)).setter(CreateFunctionRequest.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateFunctionRequest.getter(CreateFunctionRequest::role)).setter(CreateFunctionRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(CreateFunctionRequest.getter(CreateFunctionRequest::handler)).setter(CreateFunctionRequest.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<FunctionCode> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(CreateFunctionRequest.getter(CreateFunctionRequest::code)).setter(CreateFunctionRequest.setter(Builder::code)).constructor(FunctionCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFunctionRequest.getter(CreateFunctionRequest::description)).setter(CreateFunctionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateFunctionRequest.getter(CreateFunctionRequest::timeout)).setter(CreateFunctionRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(CreateFunctionRequest.getter(CreateFunctionRequest::memorySize)).setter(CreateFunctionRequest.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Publish").getter(CreateFunctionRequest.getter(CreateFunctionRequest::publish)).setter(CreateFunctionRequest.setter(Builder::publish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::vpcConfig)).setter(CreateFunctionRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(CreateFunctionRequest.getter(CreateFunctionRequest::packageTypeAsString)).setter(CreateFunctionRequest.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::deadLetterConfig)).setter(CreateFunctionRequest.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(CreateFunctionRequest.getter(CreateFunctionRequest::environment)).setter(CreateFunctionRequest.setter(Builder::environment)).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(CreateFunctionRequest.getter(CreateFunctionRequest::kmsKeyArn)).setter(CreateFunctionRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TracingConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::tracingConfig)).setter(CreateFunctionRequest.setter(Builder::tracingConfig)).constructor(TracingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateFunctionRequest.getter(CreateFunctionRequest::tags)).setter(CreateFunctionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(CreateFunctionRequest.getter(CreateFunctionRequest::layers)).setter(CreateFunctionRequest.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemConfigs").getter(CreateFunctionRequest.getter(CreateFunctionRequest::fileSystemConfigs)).setter(CreateFunctionRequest.setter(Builder::fileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::imageConfig)).setter(CreateFunctionRequest.setter(Builder::imageConfig)).constructor(ImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()}).build();
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigArn").getter(CreateFunctionRequest.getter(CreateFunctionRequest::codeSigningConfigArn)).setter(CreateFunctionRequest.setter(Builder::codeSigningConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, PUBLISH_FIELD, VPC_CONFIG_FIELD, PACKAGE_TYPE_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, TAGS_FIELD, LAYERS_FIELD, FILE_SYSTEM_CONFIGS_FIELD, IMAGE_CONFIG_FIELD, CODE_SIGNING_CONFIG_ARN_FIELD));
    private final String functionName;
    private final String runtime;
    private final String role;
    private final String handler;
    private final FunctionCode code;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final Boolean publish;
    private final VpcConfig vpcConfig;
    private final String packageType;
    private final DeadLetterConfig deadLetterConfig;
    private final Environment environment;
    private final String kmsKeyArn;
    private final TracingConfig tracingConfig;
    private final Map<String, String> tags;
    private final List<String> layers;
    private final List<FileSystemConfig> fileSystemConfigs;
    private final ImageConfig imageConfig;
    private final String codeSigningConfigArn;

    private CreateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.code = builder.code;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.publish = builder.publish;
        this.vpcConfig = builder.vpcConfig;
        this.packageType = builder.packageType;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.tags = builder.tags;
        this.layers = builder.layers;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.imageConfig = builder.imageConfig;
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
    }

    public String functionName() {
        return this.functionName;
    }

    public Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public String runtimeAsString() {
        return this.runtime;
    }

    public String role() {
        return this.role;
    }

    public String handler() {
        return this.handler;
    }

    public FunctionCode code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public Boolean publish() {
        return this.publish;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public String packageTypeAsString() {
        return this.packageType;
    }

    public DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public Environment environment() {
        return this.environment;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public TracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public List<String> layers() {
        return this.layers;
    }

    public boolean hasFileSystemConfigs() {
        return this.fileSystemConfigs != null && !(this.fileSystemConfigs instanceof SdkAutoConstructList);
    }

    public List<FileSystemConfig> fileSystemConfigs() {
        return this.fileSystemConfigs;
    }

    public ImageConfig imageConfig() {
        return this.imageConfig;
    }

    public String codeSigningConfigArn() {
        return this.codeSigningConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.publish());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionRequest)) {
            return false;
        }
        CreateFunctionRequest other = (CreateFunctionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.publish(), other.publish()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && this.hasFileSystemConfigs() == other.hasFileSystemConfigs() && Objects.equals(this.fileSystemConfigs(), other.fileSystemConfigs()) && Objects.equals(this.imageConfig(), other.imageConfig()) && Objects.equals(this.codeSigningConfigArn(), other.codeSigningConfigArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateFunctionRequest").add("FunctionName", (Object)this.functionName()).add("Runtime", (Object)this.runtimeAsString()).add("Role", (Object)this.role()).add("Handler", (Object)this.handler()).add("Code", (Object)this.code()).add("Description", (Object)this.description()).add("Timeout", (Object)this.timeout()).add("MemorySize", (Object)this.memorySize()).add("Publish", (Object)this.publish()).add("VpcConfig", (Object)this.vpcConfig()).add("PackageType", (Object)this.packageTypeAsString()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("Environment", (Object)this.environment()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("TracingConfig", (Object)this.tracingConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("Layers", this.hasLayers() ? this.layers() : null).add("FileSystemConfigs", this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null).add("ImageConfig", (Object)this.imageConfig()).add("CodeSigningConfigArn", (Object)this.codeSigningConfigArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "Publish": {
                return Optional.ofNullable(clazz.cast(this.publish()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "FileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfigs()));
            }
            case "ImageConfig": {
                return Optional.ofNullable(clazz.cast(this.imageConfig()));
            }
            case "CodeSigningConfigArn": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionRequest, T> g) {
        return obj -> g.apply((CreateFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String runtime;
        private String role;
        private String handler;
        private FunctionCode code;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private Boolean publish;
        private VpcConfig vpcConfig;
        private String packageType;
        private DeadLetterConfig deadLetterConfig;
        private Environment environment;
        private String kmsKeyArn;
        private TracingConfig tracingConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> layers = DefaultSdkAutoConstructList.getInstance();
        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();
        private ImageConfig imageConfig;
        private String codeSigningConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.runtime(model.runtime);
            this.role(model.role);
            this.handler(model.handler);
            this.code(model.code);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.publish(model.publish);
            this.vpcConfig(model.vpcConfig);
            this.packageType(model.packageType);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.tags(model.tags);
            this.layers(model.layers);
            this.fileSystemConfigs(model.fileSystemConfigs);
            this.imageConfig(model.imageConfig);
            this.codeSigningConfigArn(model.codeSigningConfigArn);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final FunctionCode.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        @Override
        public final Builder code(FunctionCode code) {
            this.code = code;
            return this;
        }

        public final void setCode(FunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final Boolean getPublish() {
            return this.publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<String> getLayers() {
            if (this.layers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layers;
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        public final Collection<FileSystemConfig.Builder> getFileSystemConfigs() {
            if (this.fileSystemConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileSystemConfigs != null ? (Collection)this.fileSystemConfigs.stream().map(FileSystemConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig ... fileSystemConfigs) {
            this.fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... fileSystemConfigs) {
            this.fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> (FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        public final ImageConfig.Builder getImageConfig() {
            return this.imageConfig != null ? this.imageConfig.toBuilder() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        public final String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionRequest build() {
            return new CreateFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFunctionRequest> {
        public Builder functionName(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder code(FunctionCode var1);

        default public Builder code(Consumer<FunctionCode.Builder> code) {
            return this.code((FunctionCode)((FunctionCode.Builder)FunctionCode.builder().applyMutation(code)).build());
        }

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder publish(Boolean var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().applyMutation(environment)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfig var1);

        default public Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfig)((TracingConfig.Builder)TracingConfig.builder().applyMutation(tracingConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder layers(Collection<String> var1);

        public Builder layers(String ... var1);

        public Builder fileSystemConfigs(Collection<FileSystemConfig> var1);

        public Builder fileSystemConfigs(FileSystemConfig ... var1);

        public Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... var1);

        public Builder imageConfig(ImageConfig var1);

        default public Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return this.imageConfig((ImageConfig)((ImageConfig.Builder)ImageConfig.builder().applyMutation(imageConfig)).build());
        }

        public Builder codeSigningConfigArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

