/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LayerVersionsListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayersListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayersListItem> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerName").getter(LayersListItem.getter(LayersListItem::layerName)).setter(LayersListItem.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerName").build()}).build();
    private static final SdkField<String> LAYER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerArn").getter(LayersListItem.getter(LayersListItem::layerArn)).setter(LayersListItem.setter(Builder::layerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerArn").build()}).build();
    private static final SdkField<LayerVersionsListItem> LATEST_MATCHING_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestMatchingVersion").getter(LayersListItem.getter(LayersListItem::latestMatchingVersion)).setter(LayersListItem.setter(Builder::latestMatchingVersion)).constructor(LayerVersionsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMatchingVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD, LAYER_ARN_FIELD, LATEST_MATCHING_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String layerName;
    private final String layerArn;
    private final LayerVersionsListItem latestMatchingVersion;

    private LayersListItem(BuilderImpl builder) {
        this.layerName = builder.layerName;
        this.layerArn = builder.layerArn;
        this.latestMatchingVersion = builder.latestMatchingVersion;
    }

    public String layerName() {
        return this.layerName;
    }

    public String layerArn() {
        return this.layerArn;
    }

    public LayerVersionsListItem latestMatchingVersion() {
        return this.latestMatchingVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestMatchingVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayersListItem)) {
            return false;
        }
        LayersListItem other = (LayersListItem)obj;
        return Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.layerArn(), other.layerArn()) && Objects.equals(this.latestMatchingVersion(), other.latestMatchingVersion());
    }

    public String toString() {
        return ToString.builder((String)"LayersListItem").add("LayerName", (Object)this.layerName()).add("LayerArn", (Object)this.layerArn()).add("LatestMatchingVersion", (Object)this.latestMatchingVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "LayerArn": {
                return Optional.ofNullable(clazz.cast(this.layerArn()));
            }
            case "LatestMatchingVersion": {
                return Optional.ofNullable(clazz.cast(this.latestMatchingVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayersListItem, T> g) {
        return obj -> g.apply((LayersListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerName;
        private String layerArn;
        private LayerVersionsListItem latestMatchingVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LayersListItem model) {
            this.layerName(model.layerName);
            this.layerArn(model.layerArn);
            this.latestMatchingVersion(model.latestMatchingVersion);
        }

        public final String getLayerName() {
            return this.layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final String getLayerArn() {
            return this.layerArn;
        }

        @Override
        public final Builder layerArn(String layerArn) {
            this.layerArn = layerArn;
            return this;
        }

        public final void setLayerArn(String layerArn) {
            this.layerArn = layerArn;
        }

        public final LayerVersionsListItem.Builder getLatestMatchingVersion() {
            return this.latestMatchingVersion != null ? this.latestMatchingVersion.toBuilder() : null;
        }

        @Override
        public final Builder latestMatchingVersion(LayerVersionsListItem latestMatchingVersion) {
            this.latestMatchingVersion = latestMatchingVersion;
            return this;
        }

        public final void setLatestMatchingVersion(LayerVersionsListItem.BuilderImpl latestMatchingVersion) {
            this.latestMatchingVersion = latestMatchingVersion != null ? latestMatchingVersion.build() : null;
        }

        public LayersListItem build() {
            return new LayersListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayersListItem> {
        public Builder layerName(String var1);

        public Builder layerArn(String var1);

        public Builder latestMatchingVersion(LayerVersionsListItem var1);

        default public Builder latestMatchingVersion(Consumer<LayerVersionsListItem.Builder> latestMatchingVersion) {
            return this.latestMatchingVersion((LayerVersionsListItem)((LayerVersionsListItem.Builder)LayerVersionsListItem.builder().applyMutation(latestMatchingVersion)).build());
        }
    }
}

