/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfig;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfigListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeSigningConfigsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListCodeSigningConfigsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListCodeSigningConfigsResponse.getter(ListCodeSigningConfigsResponse::nextMarker)).setter(ListCodeSigningConfigsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<CodeSigningConfig>> CODE_SIGNING_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CodeSigningConfigs").getter(ListCodeSigningConfigsResponse.getter(ListCodeSigningConfigsResponse::codeSigningConfigs)).setter(ListCodeSigningConfigsResponse.setter(Builder::codeSigningConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSigningConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, CODE_SIGNING_CONFIGS_FIELD));
    private final String nextMarker;
    private final List<CodeSigningConfig> codeSigningConfigs;

    private ListCodeSigningConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.codeSigningConfigs = builder.codeSigningConfigs;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public boolean hasCodeSigningConfigs() {
        return this.codeSigningConfigs != null && !(this.codeSigningConfigs instanceof SdkAutoConstructList);
    }

    public List<CodeSigningConfig> codeSigningConfigs() {
        return this.codeSigningConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeSigningConfigs() ? this.codeSigningConfigs() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSigningConfigsResponse)) {
            return false;
        }
        ListCodeSigningConfigsResponse other = (ListCodeSigningConfigsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasCodeSigningConfigs() == other.hasCodeSigningConfigs() && Objects.equals(this.codeSigningConfigs(), other.codeSigningConfigs());
    }

    public String toString() {
        return ToString.builder((String)"ListCodeSigningConfigsResponse").add("NextMarker", (Object)this.nextMarker()).add("CodeSigningConfigs", this.hasCodeSigningConfigs() ? this.codeSigningConfigs() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "CodeSigningConfigs": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSigningConfigsResponse, T> g) {
        return obj -> g.apply((ListCodeSigningConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<CodeSigningConfig> codeSigningConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSigningConfigsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.codeSigningConfigs(model.codeSigningConfigs);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<CodeSigningConfig.Builder> getCodeSigningConfigs() {
            if (this.codeSigningConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.codeSigningConfigs != null ? (Collection)this.codeSigningConfigs.stream().map(CodeSigningConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeSigningConfigs(Collection<CodeSigningConfig> codeSigningConfigs) {
            this.codeSigningConfigs = CodeSigningConfigListCopier.copy(codeSigningConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSigningConfigs(CodeSigningConfig ... codeSigningConfigs) {
            this.codeSigningConfigs(Arrays.asList(codeSigningConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSigningConfigs(Consumer<CodeSigningConfig.Builder> ... codeSigningConfigs) {
            this.codeSigningConfigs(Stream.of(codeSigningConfigs).map(c -> (CodeSigningConfig)((CodeSigningConfig.Builder)CodeSigningConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCodeSigningConfigs(Collection<CodeSigningConfig.BuilderImpl> codeSigningConfigs) {
            this.codeSigningConfigs = CodeSigningConfigListCopier.copyFromBuilder(codeSigningConfigs);
        }

        @Override
        public ListCodeSigningConfigsResponse build() {
            return new ListCodeSigningConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeSigningConfigsResponse> {
        public Builder nextMarker(String var1);

        public Builder codeSigningConfigs(Collection<CodeSigningConfig> var1);

        public Builder codeSigningConfigs(CodeSigningConfig ... var1);

        public Builder codeSigningConfigs(Consumer<CodeSigningConfig.Builder> ... var1);
    }
}

