/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.FunctionVersion;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionsRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, ListFunctionsRequest> {
    private static final SdkField<String> MASTER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFunctionsRequest.getter(ListFunctionsRequest::masterRegion)).setter(ListFunctionsRequest.setter(Builder::masterRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MasterRegion").build()}).build();
    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFunctionsRequest.getter(ListFunctionsRequest::functionVersionAsString)).setter(ListFunctionsRequest.setter(Builder::functionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FunctionVersion").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFunctionsRequest.getter(ListFunctionsRequest::marker)).setter(ListFunctionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListFunctionsRequest.getter(ListFunctionsRequest::maxItems)).setter(ListFunctionsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_REGION_FIELD, FUNCTION_VERSION_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String masterRegion;
    private final String functionVersion;
    private final String marker;
    private final Integer maxItems;

    private ListFunctionsRequest(BuilderImpl builder) {
        super(builder);
        this.masterRegion = builder.masterRegion;
        this.functionVersion = builder.functionVersion;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public String masterRegion() {
        return this.masterRegion;
    }

    public FunctionVersion functionVersion() {
        return FunctionVersion.fromValue(this.functionVersion);
    }

    public String functionVersionAsString() {
        return this.functionVersion;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.masterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsRequest)) {
            return false;
        }
        ListFunctionsRequest other = (ListFunctionsRequest)((Object)obj);
        return Objects.equals(this.masterRegion(), other.masterRegion()) && Objects.equals(this.functionVersionAsString(), other.functionVersionAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListFunctionsRequest").add("MasterRegion", (Object)this.masterRegion()).add("FunctionVersion", (Object)this.functionVersionAsString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterRegion": {
                return Optional.ofNullable(clazz.cast(this.masterRegion()));
            }
            case "FunctionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersionAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsRequest, T> g) {
        return obj -> g.apply((ListFunctionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String masterRegion;
        private String functionVersion;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsRequest model) {
            super(model);
            this.masterRegion(model.masterRegion);
            this.functionVersion(model.functionVersion);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getMasterRegion() {
            return this.masterRegion;
        }

        @Override
        public final Builder masterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
            return this;
        }

        public final void setMasterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        @Override
        public final Builder functionVersion(FunctionVersion functionVersion) {
            this.functionVersion(functionVersion.toString());
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFunctionsRequest build() {
            return new ListFunctionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionsRequest> {
        public Builder masterRegion(String var1);

        public Builder functionVersion(String var1);

        public Builder functionVersion(FunctionVersion var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

