/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.transform.DeadLetterConfigUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.EnvironmentResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.TracingConfigResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.VpcConfigResponseUnmarshaller;

public class FunctionConfigurationUnmarshaller
implements Unmarshaller<FunctionConfiguration, JsonUnmarshallerContext> {
    private static final FunctionConfigurationUnmarshaller INSTANCE = new FunctionConfigurationUnmarshaller();

    public FunctionConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        FunctionConfiguration.Builder functionConfigurationBuilder = FunctionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("FunctionName", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.functionName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FunctionArn", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.functionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Runtime", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.runtime((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Role", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.role((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Handler", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.handler((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CodeSize", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.codeSize((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Timeout", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.timeout((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MemorySize", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.memorySize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.lastModified((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CodeSha256", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.codeSha256((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcConfig", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.vpcConfig(VpcConfigResponseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DeadLetterConfig", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.deadLetterConfig(DeadLetterConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Environment", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.environment(EnvironmentResponseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KMSKeyArn", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.kmsKeyArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TracingConfig", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.tracingConfig(TracingConfigResponseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MasterArn", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.masterArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RevisionId", targetDepth)) {
                    context.nextToken();
                    functionConfigurationBuilder.revisionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FunctionConfiguration)functionConfigurationBuilder.build();
    }

    public static FunctionConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

